/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.fodupload.SharedPollingBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class PollingBuildStep
extends Recorder
implements SimpleBuildStep {
    SharedPollingBuildStep sharedBuildStep;

    @DataBoundConstructor
    public PollingBuildStep(String bsiToken, boolean overrideGlobalConfig, int pollingInterval, int policyFailureBuildResultPreference, String clientId, String clientSecret, String username, String personalAccessToken, String tenantId) {
        this.sharedBuildStep = new SharedPollingBuildStep(bsiToken, overrideGlobalConfig, pollingInterval, policyFailureBuildResultPreference, clientId, clientSecret, username, personalAccessToken, tenantId);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        this.sharedBuildStep.perform(run, filePath, launcher, taskListener);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getBsiToken() {
        return this.sharedBuildStep.getBsiToken();
    }

    public int getPollingInterval() {
        return this.sharedBuildStep.getPollingInterval();
    }

    public int getPolicyFailureBuildResultPreference() {
        return this.sharedBuildStep.getPolicyFailureBuildResultPreference();
    }

    public String getUsername() {
        return this.sharedBuildStep.getAuthModel().getUsername();
    }

    public String getPersonalAccessToken() {
        return this.sharedBuildStep.getAuthModel().getPersonalAccessToken();
    }

    public String getTenantId() {
        return this.sharedBuildStep.getAuthModel().getTenantId();
    }

    public boolean getOverrideGlobalConfig() {
        return this.sharedBuildStep.getAuthModel().getOverrideGlobalConfig();
    }

    public PollingStepDescriptor getDescriptor() {
        return (PollingStepDescriptor)super.getDescriptor();
    }

    @Extension
    public static final class PollingStepDescriptor
    extends BuildStepDescriptor<Publisher> {
        public PollingStepDescriptor() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Poll Fortify on Demand for Results";
        }

        public FormValidation doCheckBsiToken(@QueryParameter String bsiToken) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SharedPollingBuildStep.doCheckBsiToken(bsiToken);
        }

        public FormValidation doCheckPollingInterval(@QueryParameter String pollingInterval) {
            return SharedPollingBuildStep.doCheckPollingInterval(pollingInterval);
        }

        @POST
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public FormValidation doTestPersonalAccessTokenConnection(@QueryParameter(value="username") String username, @QueryParameter(value="personalAccessToken") String personalAccessToken, @QueryParameter(value="tenantId") String tenantId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return SharedPollingBuildStep.doTestPersonalAccessTokenConnection(username, personalAccessToken, tenantId);
        }

        public ListBoxModel doFillPolicyFailureBuildResultPreferenceItems() {
            return SharedPollingBuildStep.doFillPolicyFailureBuildResultPreferenceItems();
        }

        public ListBoxModel doFillUsernameItems() {
            return SharedPollingBuildStep.doFillStringCredentialsItems();
        }

        public ListBoxModel doFillPersonalAccessTokenItems() {
            return SharedPollingBuildStep.doFillStringCredentialsItems();
        }

        public ListBoxModel doFillTenantIdItems() {
            return SharedPollingBuildStep.doFillStringCredentialsItems();
        }
    }
}

