/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.fodupload.FodApiConnection;
import org.jenkinsci.plugins.fodupload.SharedUploadBuildStep;
import org.jenkinsci.plugins.fodupload.Utils;
import org.jenkinsci.plugins.fodupload.models.FodEnums;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

@Extension
public class FodGlobalDescriptor
extends GlobalConfiguration {
    private static final String CLIENT_ID = "clientId";
    private static final String GLOBAL_AUTH_TYPE = "globalAuthType";
    private static final String CLIENT_SECRET = "clientSecret";
    private static final String USERNAME = "username";
    private static final String PERSONAL_ACCESS_TOKEN = "personalAccessToken";
    private static final String TENANT_ID = "tenantId";
    private static final String BASE_URL = "baseUrl";
    private static final String API_URL = "apiUrl";
    private String globalAuthType;
    private String clientId;
    private String clientSecret;
    private String username;
    private String personalAccessToken;
    private String tenantId;
    private String baseUrl;
    private String apiUrl;

    public FodGlobalDescriptor() {
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        JSONObject globalAuthTypeObject = formData.getJSONObject(GLOBAL_AUTH_TYPE);
        if (globalAuthTypeObject.size() > 0) {
            this.globalAuthType = globalAuthTypeObject.getString("value");
            if (this.globalAuthType.equals("apiKeyType")) {
                this.clientId = globalAuthTypeObject.getString(CLIENT_ID);
                this.clientSecret = globalAuthTypeObject.getString(CLIENT_SECRET);
            } else if (this.globalAuthType.equals("personalAccessTokenType")) {
                this.username = globalAuthTypeObject.getString(USERNAME);
                this.personalAccessToken = globalAuthTypeObject.getString(PERSONAL_ACCESS_TOKEN);
                this.tenantId = globalAuthTypeObject.getString(TENANT_ID);
            }
        }
        this.baseUrl = formData.getString(BASE_URL);
        this.apiUrl = formData.getString(API_URL);
        this.save();
        return super.configure(req, formData);
    }

    public String getDisplayName() {
        return "Fortify Uploader Plugin";
    }

    public String getGlobalAuthType() {
        return this.globalAuthType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getOriginalClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getOriginalClientSecret() {
        return this.clientSecret;
    }

    public String getUsername() {
        return this.username;
    }

    public String getOriginalUsername() {
        return this.username;
    }

    public String getPersonalAccessToken() {
        return this.personalAccessToken;
    }

    public String getOriginalPersonalAccessToken() {
        return this.personalAccessToken;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getOriginalTenantId() {
        return this.tenantId;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public boolean getAuthTypeIsApiKey() {
        return this.globalAuthType.equals("apiKeyType");
    }

    public boolean getAuthTypeIsPersonalToken() {
        return this.globalAuthType.equals("personalAccessTokenType");
    }

    @POST
    public FormValidation doTestApiKeyConnection(@QueryParameter(value="clientId") String clientId, @QueryParameter(value="clientSecret") String clientSecret, @QueryParameter(value="baseUrl") String baseUrl, @QueryParameter(value="apiUrl") String apiUrl) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        String plainTextClientSecret = Utils.retrieveSecretDecryptedValue(clientSecret);
        if (Utils.isNullOrEmpty(baseUrl)) {
            return FormValidation.error((String)"Fortify on Demand URL is empty!");
        }
        if (Utils.isNullOrEmpty(apiUrl)) {
            return FormValidation.error((String)"Fortify on Demand API URL is empty!");
        }
        if (Utils.isNullOrEmpty(clientId)) {
            return FormValidation.error((String)"API Key is empty!");
        }
        if (!Utils.isCredential(clientSecret)) {
            return FormValidation.error((String)"Secret Key is empty or needs to be resaved!");
        }
        FodApiConnection testApi = new FodApiConnection(clientId, plainTextClientSecret, baseUrl, apiUrl, FodEnums.GrantType.CLIENT_CREDENTIALS, "api-tenant");
        return this.testConnection(testApi);
    }

    @POST
    public FormValidation doTestPersonalAccessTokenConnection(@QueryParameter(value="username") String username, @QueryParameter(value="personalAccessToken") String personalAccessToken, @QueryParameter(value="tenantId") String tenantId, @QueryParameter(value="baseUrl") String baseUrl, @QueryParameter(value="apiUrl") String apiUrl) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        String plainTextPersonalAccessToken = Utils.retrieveSecretDecryptedValue(personalAccessToken);
        if (Utils.isNullOrEmpty(baseUrl)) {
            return FormValidation.error((String)"Fortify on Demand URL is empty!");
        }
        if (Utils.isNullOrEmpty(apiUrl)) {
            return FormValidation.error((String)"Fortify on Demand API URL is empty!");
        }
        if (Utils.isNullOrEmpty(username)) {
            return FormValidation.error((String)"Username is empty!");
        }
        if (!Utils.isCredential(personalAccessToken)) {
            return FormValidation.error((String)"Personal Access Token is empty! Please update and save credentials.");
        }
        if (Utils.isNullOrEmpty(tenantId)) {
            return FormValidation.error((String)"Tenant ID is null.");
        }
        FodApiConnection testApi = new FodApiConnection(tenantId + "\\" + username, plainTextPersonalAccessToken, baseUrl, apiUrl, FodEnums.GrantType.PASSWORD, "api-tenant");
        return this.testConnection(testApi);
    }

    public ListBoxModel doFillClientIdItems() {
        return SharedUploadBuildStep.doFillStringCredentialsItems();
    }

    public ListBoxModel doFillClientSecretItems() {
        return SharedUploadBuildStep.doFillStringCredentialsItems();
    }

    public ListBoxModel doFillUsernameItems() {
        return SharedUploadBuildStep.doFillStringCredentialsItems();
    }

    public ListBoxModel doFillPersonalAccessTokenItems() {
        return SharedUploadBuildStep.doFillStringCredentialsItems();
    }

    public ListBoxModel doFillTenantIdItems() {
        return SharedUploadBuildStep.doFillStringCredentialsItems();
    }

    FodApiConnection createFodApiConnection() {
        if (!Utils.isNullOrEmpty(this.globalAuthType)) {
            if (Utils.isNullOrEmpty(this.baseUrl)) {
                throw new IllegalArgumentException("Base URL is null.");
            }
            if (Utils.isNullOrEmpty(this.apiUrl)) {
                throw new IllegalArgumentException("Api URL is null.");
            }
            if (this.globalAuthType.equals("apiKeyType")) {
                if (Utils.isNullOrEmpty(this.clientId)) {
                    throw new IllegalArgumentException("Client ID is null.");
                }
                if (Utils.isNullOrEmpty(this.clientSecret)) {
                    throw new IllegalArgumentException("Client Secret is null.");
                }
                return new FodApiConnection(this.clientId, Utils.retrieveSecretDecryptedValue(this.clientSecret), this.baseUrl, this.apiUrl, FodEnums.GrantType.CLIENT_CREDENTIALS, "api-tenant");
            }
            if (this.globalAuthType.equals("personalAccessTokenType")) {
                if (Utils.isNullOrEmpty(this.username)) {
                    throw new IllegalArgumentException("Username is null.");
                }
                if (Utils.isNullOrEmpty(this.personalAccessToken)) {
                    throw new IllegalArgumentException("Personal Access Token is null.");
                }
                if (Utils.isNullOrEmpty(this.tenantId)) {
                    throw new IllegalArgumentException("Tenant ID is null.");
                }
                return new FodApiConnection(this.tenantId + "\\" + this.username, Utils.retrieveSecretDecryptedValue(this.personalAccessToken), this.baseUrl, this.apiUrl, FodEnums.GrantType.PASSWORD, "api-tenant");
            }
            throw new IllegalArgumentException("Invalid authentication type");
        }
        throw new IllegalArgumentException("No authentication method configured");
    }

    public FormValidation testConnection(FodApiConnection testApi) {
        try {
            testApi.authenticate();
        }
        catch (IOException e) {
            return FormValidation.error((String)("Unable to authenticate with Fortify on Demand. Error Message: " + e.getMessage()));
        }
        String token = testApi.getToken();
        if (token == null) {
            return FormValidation.error((String)"Unable to retrieve authentication token.");
        }
        return !token.isEmpty() ? FormValidation.ok((String)"Successfully authenticated to Fortify on Demand.") : FormValidation.error((String)"Invalid connection information. Please check your credentials and try again.");
    }
}

