/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jenkins.model.GlobalConfiguration;
import org.jenkinsci.plugins.fodupload.FodApiConnection;
import org.jenkinsci.plugins.fodupload.FodGlobalDescriptor;
import org.jenkinsci.plugins.fodupload.Utils;
import org.jenkinsci.plugins.fodupload.models.AuthenticationModel;
import org.jenkinsci.plugins.fodupload.models.FodEnums;

public class ApiConnectionFactory {
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static FodApiConnection createApiConnection(AuthenticationModel model) {
        FodApiConnection apiConnection = null;
        if (GlobalConfiguration.all() != null && GlobalConfiguration.all().get(FodGlobalDescriptor.class) != null) {
            if (model.getOverrideGlobalConfig()) {
                String baseUrl = ((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).getBaseUrl();
                String apiUrl = ((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).getApiUrl();
                if (Utils.isNullOrEmpty(baseUrl)) {
                    throw new IllegalArgumentException("Base URL is null.");
                }
                if (Utils.isNullOrEmpty(apiUrl)) {
                    throw new IllegalArgumentException("Api URL is null.");
                }
                apiConnection = new FodApiConnection(model.getTenantId() + "\\" + model.getUsername(), Utils.retrieveSecretDecryptedValue(model.getPersonalAccessToken()), baseUrl, apiUrl, FodEnums.GrantType.PASSWORD, "api-tenant");
            } else {
                apiConnection = ((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).createFodApiConnection();
            }
        }
        return apiConnection;
    }
}

