/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload.polling;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.fodupload.FodApiConnection;
import org.jenkinsci.plugins.fodupload.Utils;
import org.jenkinsci.plugins.fodupload.controllers.LookupItemsController;
import org.jenkinsci.plugins.fodupload.controllers.ReleaseController;
import org.jenkinsci.plugins.fodupload.models.FodEnums;
import org.jenkinsci.plugins.fodupload.models.response.LookupItemsModel;
import org.jenkinsci.plugins.fodupload.models.response.ReleaseDTO;
import org.jenkinsci.plugins.fodupload.polling.PollReleaseStatusResult;

public class ScanStatusPoller {
    private static final int MAX_FAILS = 3;
    private FodApiConnection apiConnection;
    private int failCount = 0;
    private int pollingInterval;
    private PrintStream logger;

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    public ScanStatusPoller(FodApiConnection apiConnection, int pollingInterval, PrintStream logger) {
        this.apiConnection = apiConnection;
        this.pollingInterval = pollingInterval;
        this.logger = logger;
    }

    public PollReleaseStatusResult pollReleaseStatus(int releaseId) throws IOException, InterruptedException {
        LookupItemsController lookupItemsController = new LookupItemsController(this.apiConnection);
        ReleaseController releaseController = new ReleaseController(this.apiConnection);
        PollReleaseStatusResult result = new PollReleaseStatusResult();
        List<LookupItemsModel> analysisStatusTypes = null;
        this.logger.println("Begin polling Fortify on Demand for results.");
        boolean finished = false;
        int counter = 0;
        while (!finished) {
            if (counter != 0) {
                Thread.sleep(60000L * (long)this.pollingInterval);
            }
            ++counter;
            ReleaseDTO release = releaseController.getRelease(releaseId, "currentAnalysisStatusTypeId,isPassed,passFailReasonId,critical,high,medium,low,releaseId,rating,currentStaticScanId,releaseName");
            if (release == null) {
                ++this.failCount;
                continue;
            }
            int status = release.getCurrentAnalysisStatusTypeId();
            if (analysisStatusTypes == null) {
                analysisStatusTypes = lookupItemsController.getLookupItems(FodEnums.APILookupItemTypes.AnalysisStatusTypes);
            }
            if (this.failCount < 3) {
                String statusString = "";
                ArrayList<String> complete = new ArrayList<String>();
                for (LookupItemsModel item : analysisStatusTypes) {
                    if (!item.getText().equalsIgnoreCase("Completed") && !item.getText().equalsIgnoreCase("Canceled")) continue;
                    complete.add(item.getValue());
                }
                for (LookupItemsModel o : analysisStatusTypes) {
                    if (o == null) continue;
                    int analysisStatus = Integer.parseInt(o.getValue());
                    if (analysisStatus == status) {
                        statusString = o.getText().replace("_", " ");
                    }
                    if (!complete.contains(Integer.toString(status))) continue;
                    finished = true;
                }
                this.logger.println(counter + ") Poll Status: " + statusString);
                if (!finished) continue;
                result.setPassing(release.isPassed());
                result.setPollingSuccessful(true);
                if (!Utils.isNullOrEmpty(release.getPassFailReasonType())) {
                    result.setFailReason(release.getPassFailReasonType());
                }
                this.printPassFail(release);
                continue;
            }
            this.logger.println(String.format("Polling Failed %d times.  Terminating", 3));
            finished = true;
        }
        return result;
    }

    private void printPassFail(ReleaseDTO release) {
        boolean isPassed = release.isPassed();
        this.logger.println(String.format("Critical: %d", release.getCritical()));
        this.logger.println(String.format("High:     %d", release.getHigh()));
        this.logger.println(String.format("Medium:   %d", release.getMedium()));
        this.logger.println(String.format("Low:      %d", release.getLow()));
        this.logger.println("For application status details see the customer portal: ");
        this.logger.println(String.format("%s/Redirect/Releases/%d", this.apiConnection.getBaseUrl(), release.getReleaseId()));
        this.logger.println(String.format("Scan %s established policy check", isPassed ? "passed" : "failed"));
        if (!isPassed) {
            String passFailReason = release.getPassFailReasonType() == null ? "Pass/Fail Policy requirements not met " : release.getPassFailReasonType();
            this.logger.println("Failure Reason:         " + passFailReason);
        }
    }
}

