/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload.models;

import com.fortify.fod.parser.BsiToken;
import com.fortify.fod.parser.BsiTokenParser;
import java.io.File;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class JobModel {
    private static final BsiTokenParser tokenParser = new BsiTokenParser();
    private String bsiTokenOriginal;
    private transient BsiToken bsiTokenCache;
    private boolean includeAllFiles;
    private boolean purchaseEntitlements;
    private int entitlementPreference;
    private boolean isBundledAssessment;
    private boolean isRemediationPreferred;
    private boolean runOpenSourceAnalysisOverride;
    private boolean isExpressScanOverride;
    private boolean isExpressAuditOverride;
    private boolean includeThirdPartyOverride;
    private File payload;

    public File getPayload() {
        return this.payload;
    }

    public void setPayload(File payload) {
        this.payload = payload;
    }

    public BsiToken getBsiToken() {
        return this.bsiTokenCache;
    }

    public boolean isIncludeAllFiles() {
        return this.includeAllFiles;
    }

    public boolean isPurchaseEntitlements() {
        return this.purchaseEntitlements;
    }

    public int getEntitlementPreference() {
        return this.entitlementPreference;
    }

    public boolean isBundledAssessment() {
        return this.isBundledAssessment;
    }

    public String getBsiTokenOriginal() {
        return this.bsiTokenOriginal;
    }

    public boolean isRemediationPreferred() {
        return this.isRemediationPreferred;
    }

    public JobModel(String bsiToken, boolean includeAllFiles, boolean isBundledAssessment, boolean purchaseEntitlements, int entitlementPreference, boolean isRemediationPreferred, boolean runOpenSourceAnalysisOverride, boolean isExpressScanOverride, boolean isExpressAuditOverride, boolean includeThirdPartyOverride) throws URISyntaxException, UnsupportedEncodingException {
        this.bsiTokenOriginal = bsiToken;
        this.includeAllFiles = includeAllFiles;
        this.entitlementPreference = entitlementPreference;
        this.isBundledAssessment = isBundledAssessment;
        this.purchaseEntitlements = purchaseEntitlements;
        this.isRemediationPreferred = isRemediationPreferred;
        this.runOpenSourceAnalysisOverride = runOpenSourceAnalysisOverride;
        this.isExpressScanOverride = isExpressScanOverride;
        this.isExpressAuditOverride = isExpressAuditOverride;
        this.includeThirdPartyOverride = includeThirdPartyOverride;
    }

    private Object readResolve() throws URISyntaxException, UnsupportedEncodingException {
        this.bsiTokenCache = tokenParser.parse(this.bsiTokenOriginal);
        return this;
    }

    public String toString() {
        return String.format("Release Id:                        %s%nAssessment Type Id:                %s%nTechnology Stack:                  %s%nLanguage Level:                    %s%nInclude All Files:                 %s%nPurchase Entitlements:             %s%nEntitlement Preference             %s%nBundled Assessment:                %s%n", this.bsiTokenCache.getProjectVersionId(), this.bsiTokenCache.getAssessmentTypeId(), this.bsiTokenCache.getTechnologyStack(), this.bsiTokenCache.getLanguageLevel(), this.includeAllFiles, this.purchaseEntitlements, this.entitlementPreference, this.isBundledAssessment);
    }

    public boolean initializeBuildModel() {
        try {
            this.bsiTokenCache = tokenParser.parse(this.bsiTokenOriginal);
        }
        catch (Exception ex) {
            return false;
        }
        return this.bsiTokenCache != null;
    }

    public boolean validate(PrintStream logger) {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.bsiTokenCache.getAssessmentTypeId() == 0) {
            errors.add("Assessment Type");
        }
        if (this.bsiTokenCache.getTechnologyType() == null) {
            errors.add("Technology Stack");
        }
        if (this.bsiTokenCache.getProjectVersionId() == 0) {
            errors.add("Release Id");
        }
        if (errors.size() > 0) {
            logger.println("Missing the following fields from BSI Token: ");
            for (String error : errors) {
                logger.println("    " + error);
            }
            return false;
        }
        return true;
    }

    public boolean isIncludeThirdPartyOverride() {
        return this.includeThirdPartyOverride;
    }

    public boolean isExpressAuditOverride() {
        return this.isExpressAuditOverride;
    }

    public boolean isExpressScanOverride() {
        return this.isExpressScanOverride;
    }

    public boolean isRunOpenSourceAnalysisOverride() {
        return this.runOpenSourceAnalysisOverride;
    }
}

