/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload.controllers;

import com.fortify.fod.parser.BsiToken;
import com.google.gson.Gson;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.fodupload.FodApiConnection;
import org.jenkinsci.plugins.fodupload.Utils;
import org.jenkinsci.plugins.fodupload.controllers.ControllerBase;
import org.jenkinsci.plugins.fodupload.controllers.ReleaseController;
import org.jenkinsci.plugins.fodupload.models.JobModel;
import org.jenkinsci.plugins.fodupload.models.response.GenericErrorResponse;
import org.jenkinsci.plugins.fodupload.models.response.PostStartScanResponse;
import org.jenkinsci.plugins.fodupload.models.response.ReleaseAssessmentTypeDTO;

public class StaticScanController
extends ControllerBase {
    private static final int EXPRESS_SCAN_PREFERENCE_ID = 2;
    private static final int EXPRESS_AUDIT_PREFERENCE_ID = 2;
    private static final int MAX_NOTES_LENGTH = 250;
    private static final int CHUNK_SIZE = 0x100000;
    private PrintStream logger;

    public StaticScanController(FodApiConnection apiConnection, PrintStream logger) {
        super(apiConnection);
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="The intent of the catch-all is to make sure that the Jenkins user and logs show the plugin's problem in the build log.")
    public boolean startStaticScan(JobModel uploadRequest, String notes) {
        PostStartScanResponse scanStartedResponse = null;
        File uploadFile = uploadRequest.getPayload();
        try (FileInputStream fs = new FileInputStream(uploadFile);){
            int byteCount;
            byte[] readByteArray = new byte[0x100000];
            int fragmentNumber = 0;
            long offset = 0L;
            if (this.apiConnection.getToken() == null) {
                this.apiConnection.authenticate();
            }
            this.logger.println("Getting Assessment");
            ReleaseAssessmentTypeDTO assessmentType = new ReleaseController(this.apiConnection).getAssessmentType(uploadRequest);
            if (assessmentType == null) {
                this.logger.println("Entitlement not found.  Please make sure that your entitlements are good for the selected preference.");
                boolean bl = false;
                return bl;
            }
            BsiToken token = uploadRequest.getBsiToken();
            boolean isRemediationScan = uploadRequest.isRemediationPreferred() && assessmentType.isRemediation();
            boolean excludeThirdPartyLibs = !token.getIncludeThirdParty() || !uploadRequest.isIncludeThirdPartyOverride();
            boolean includeOpenSourceScan = token.getIncludeOpenSourceAnalysis() || uploadRequest.isRunOpenSourceAnalysisOverride();
            int scanPreferenceId = uploadRequest.isExpressScanOverride() ? 2 : token.getScanPreferenceId();
            int auditPreferenceId = uploadRequest.isExpressAuditOverride() ? 2 : token.getAuditPreferenceId();
            HttpUrl.Builder builder = HttpUrl.parse((String)this.apiConnection.getApiUrl()).newBuilder().addPathSegments(String.format("/api/v3/releases/%d/static-scans/start-scan", token.getProjectVersionId())).addQueryParameter("assessmentTypeId", Integer.toString(token.getAssessmentTypeId())).addQueryParameter("technologyStack", token.getTechnologyType()).addQueryParameter("entitlementId", Integer.toString(assessmentType.getEntitlementId())).addQueryParameter("entitlementFrequencyType", Integer.toString(assessmentType.getFrequencyTypeId())).addQueryParameter("isBundledAssessment", Boolean.toString(assessmentType.isBundledAssessment())).addQueryParameter("doSonatypeScan", Boolean.toString(includeOpenSourceScan)).addQueryParameter("excludeThirdPartyLibs", Boolean.toString(excludeThirdPartyLibs)).addQueryParameter("scanPreferenceType", Integer.toString(scanPreferenceId)).addQueryParameter("auditPreferenceType", Integer.toString(auditPreferenceId)).addQueryParameter("isRemediationScan", Boolean.toString(isRemediationScan));
            if (!Utils.isNullOrEmpty(notes)) {
                String truncatedNotes = StringUtils.left((String)notes, (int)250);
                builder = builder.addQueryParameter("notes", truncatedNotes);
            }
            if (assessmentType.getParentAssessmentTypeId() != 0 && assessmentType.isBundledAssessment()) {
                builder = builder.addQueryParameter("parentAssessmentTypeId", Integer.toString(assessmentType.getParentAssessmentTypeId()));
            }
            if (token.getTechnologyVersion() != null) {
                builder = builder.addQueryParameter("languageLevel", token.getTechnologyVersion());
            }
            String fragUrl = builder.build().toString();
            this.logger.println("TOTAL FILE SIZE = " + uploadFile.length());
            this.logger.println("CHUNK_SIZE = 1048576");
            while ((byteCount = fs.read(readByteArray)) != -1) {
                byte[] sendByteArray;
                if (byteCount < 0x100000) {
                    sendByteArray = Arrays.copyOf(readByteArray, byteCount);
                    fragmentNumber = -1;
                } else {
                    sendByteArray = readByteArray;
                }
                MediaType byteArray = MediaType.parse((String)"application/octet-stream");
                Request request = new Request.Builder().addHeader("Authorization", "Bearer " + this.apiConnection.getToken()).addHeader("Content-Type", "application/octet-stream").addHeader("Accept", "application/json").url(fragUrl + "&fragNo=" + fragmentNumber++ + "&offset=" + offset).post(RequestBody.create((MediaType)byteArray, (byte[])sendByteArray)).build();
                Response response = this.apiConnection.getClient().newCall(request).execute();
                if (response.code() == 403) {
                    this.apiConnection.authenticate();
                }
                offset += (long)byteCount;
                if (fragmentNumber % 5 == 0) {
                    this.logger.println("Upload Status - Fragment No: " + fragmentNumber + ", Bytes sent: " + offset + " (Response: " + response.code() + ")");
                }
                if (response.code() != 202) {
                    String responseJsonStr = IOUtils.toString((InputStream)response.body().byteStream(), (String)"utf-8");
                    Gson gson = new Gson();
                    if (response.code() == 200) {
                        scanStartedResponse = (PostStartScanResponse)gson.fromJson(responseJsonStr, PostStartScanResponse.class);
                        this.logger.println("Scan " + scanStartedResponse.getScanId() + " uploaded successfully. Total bytes sent: " + offset);
                        boolean bl = true;
                        return bl;
                    }
                    if (!response.isSuccessful()) {
                        this.logger.println("An error occurred during the upload.");
                        GenericErrorResponse errors = (GenericErrorResponse)gson.fromJson(responseJsonStr, GenericErrorResponse.class);
                        if (errors != null) {
                            this.logger.println("Package upload failed for the following reasons: " + errors.toString());
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                response.body().close();
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace(this.logger);
            return false;
        }
    }
}

