/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload;

import com.fortify.fod.parser.BsiToken;
import com.fortify.fod.parser.BsiTokenParser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.fodupload.ApiConnectionFactory;
import org.jenkinsci.plugins.fodupload.FodApiConnection;
import org.jenkinsci.plugins.fodupload.FodGlobalDescriptor;
import org.jenkinsci.plugins.fodupload.Utils;
import org.jenkinsci.plugins.fodupload.controllers.StaticScanController;
import org.jenkinsci.plugins.fodupload.models.AuthenticationModel;
import org.jenkinsci.plugins.fodupload.models.FodEnums;
import org.jenkinsci.plugins.fodupload.models.JobModel;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class StaticAssessmentBuildStep
extends Recorder
implements SimpleBuildStep {
    private static final ThreadLocal<TaskListener> taskListener = new ThreadLocal();
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "clientSecret";
    private static final String USERNAME = "username";
    private static final String PERSONAL_ACCESS_TOKEN = "personalAccessToken";
    private static final String TENANT_ID = "tenantId";
    private JobModel model;
    private AuthenticationModel authModel;

    @DataBoundConstructor
    public StaticAssessmentBuildStep(String bsiToken, boolean overrideGlobalConfig, String username, String personalAccessToken, String tenantId, boolean includeAllFiles, boolean isBundledAssessment, boolean purchaseEntitlements, int entitlementPreference, boolean isRemediationPreferred, boolean runOpenSourceAnalysisOverride, boolean isExpressScanOverride, boolean isExpressAuditOverride, boolean includeThirdPartyOverride) throws URISyntaxException, UnsupportedEncodingException {
        this.model = new JobModel(bsiToken, includeAllFiles, isBundledAssessment, purchaseEntitlements, entitlementPreference, isRemediationPreferred, runOpenSourceAnalysisOverride, isExpressScanOverride, isExpressAuditOverride, includeThirdPartyOverride);
        this.authModel = new AuthenticationModel(overrideGlobalConfig, username, personalAccessToken, tenantId);
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        if (this.model == null) {
            logger.println("Unexpected Error");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (!this.model.initializeBuildModel()) {
            logger.println("Invalid BSI Token");
            build.setResult(Result.FAILURE);
            return false;
        }
        if (!this.model.validate(logger)) {
            build.setResult(Result.FAILURE);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) {
        PrintStream logger = listener.getLogger();
        FodApiConnection apiConnection = null;
        try {
            taskListener.set(listener);
            Result currentResult = build.getResult();
            if (Result.FAILURE.equals(currentResult) || Result.ABORTED.equals(currentResult) || Result.UNSTABLE.equals(currentResult)) {
                logger.println("Error: Build Failed or Unstable.  Halting with Fortify on Demand upload.");
                return;
            }
            logger.println("Starting FoD Upload.");
            File payload = Utils.createZipFile(this.model.getBsiToken().getTechnologyStack(), workspace, logger);
            if (payload.length() == 0L) {
                boolean deleteSuccess = payload.delete();
                if (!deleteSuccess) {
                    logger.println("Unable to delete empty payload.");
                }
                logger.println("Source is empty for given Technology Stack and Language Level.");
                build.setResult(Result.FAILURE);
                return;
            }
            this.model.setPayload(payload);
            apiConnection = ApiConnectionFactory.createApiConnection(this.authModel);
            if (apiConnection != null) {
                apiConnection.authenticate();
                StaticScanController staticScanController = new StaticScanController(apiConnection, logger);
                String notes = String.format("[%d] %s - Assessment submitted from Jenkins FoD Plugin", build.getNumber(), build.getDisplayName());
                boolean success = staticScanController.startStaticScan(this.model, notes);
                boolean deleted = payload.delete();
                if (success && deleted) {
                    logger.println("Scan Uploaded Successfully.");
                }
                build.setResult(success && deleted ? Result.SUCCESS : Result.UNSTABLE);
            } else {
                logger.println("Failed to authenticate");
                build.setResult(Result.FAILURE);
            }
        }
        catch (IOException e) {
            logger.println(e.getMessage());
            build.setResult(Result.FAILURE);
        }
        catch (IllegalArgumentException iae) {
            logger.println(iae.getMessage());
            build.setResult(Result.FAILURE);
        }
        finally {
            if (apiConnection != null) {
                try {
                    apiConnection.retireToken();
                }
                catch (IOException e) {
                    logger.println("Failed to retire oauth token.");
                    e.printStackTrace(logger);
                }
            }
        }
    }

    public StaticAssessmentStepDescriptor getDescriptor() {
        return (StaticAssessmentStepDescriptor)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getBsiToken() {
        return this.model.getBsiTokenOriginal();
    }

    public String getUsername() {
        return this.authModel.getUsername();
    }

    public String getPersonalAccessToken() {
        return this.authModel.getPersonalAccessToken();
    }

    public String getTenantId() {
        return this.authModel.getTenantId();
    }

    public boolean getOverrideGlobalConfig() {
        return this.authModel.getOverrideGlobalConfig();
    }

    public boolean getIncludeAllFiles() {
        return this.model.isIncludeAllFiles();
    }

    public int getEntitlementPreference() {
        return this.model.getEntitlementPreference();
    }

    public boolean getIsBundledAssessment() {
        return this.model.isBundledAssessment();
    }

    public boolean getPurchaseEntitlements() {
        return this.model.isPurchaseEntitlements();
    }

    public boolean getIsRemediationPreferred() {
        return this.model.isRemediationPreferred();
    }

    public boolean getRunOpenSourceAnalysisOverride() {
        return this.model.isRunOpenSourceAnalysisOverride();
    }

    public boolean getIsExpressScanOverride() {
        return this.model.isExpressScanOverride();
    }

    public boolean getIsExpressAuditOverride() {
        return this.model.isExpressAuditOverride();
    }

    public boolean getIncludeThirdPartyOverride() {
        return this.model.isIncludeThirdPartyOverride();
    }

    @Extension
    public static final class StaticAssessmentStepDescriptor
    extends BuildStepDescriptor<Publisher> {
        public StaticAssessmentStepDescriptor() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public FormValidation doCheckBsiToken(@QueryParameter String bsiToken) {
            block4: {
                if (bsiToken != null && !bsiToken.isEmpty()) {
                    BsiTokenParser tokenParser = new BsiTokenParser();
                    try {
                        BsiToken testToken = tokenParser.parse(bsiToken);
                        if (testToken != null) {
                            return FormValidation.ok();
                        }
                        break block4;
                    }
                    catch (Exception ex) {
                        return FormValidation.error((String)"Could not parse BSI token.");
                    }
                }
                return FormValidation.error((String)"Please specify BSI Token");
            }
            return FormValidation.error((String)"Please specify BSI Token");
        }

        public String getDisplayName() {
            return "Fortify on Demand Static Assessment";
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public FormValidation doTestPersonalAccessTokenConnection(@QueryParameter(value="username") String username, @QueryParameter(value="personalAccessToken") String personalAccessToken, @QueryParameter(value="tenantId") String tenantId) {
            String baseUrl = ((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).getBaseUrl();
            String apiUrl = ((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).getApiUrl();
            if (Utils.isNullOrEmpty(baseUrl)) {
                return FormValidation.error((String)"Fortify on Demand URL is empty!");
            }
            if (Utils.isNullOrEmpty(apiUrl)) {
                return FormValidation.error((String)"Fortify on Demand API URL is empty!");
            }
            if (Utils.isNullOrEmpty(username)) {
                return FormValidation.error((String)"Username is empty!");
            }
            if (Utils.isNullOrEmpty(personalAccessToken)) {
                return FormValidation.error((String)"Personal Access Token is empty!");
            }
            if (Utils.isNullOrEmpty(tenantId)) {
                return FormValidation.error((String)"Tenant ID is null.");
            }
            FodApiConnection testApi = new FodApiConnection(tenantId + "\\" + username, personalAccessToken, baseUrl, apiUrl, FodEnums.GrantType.PASSWORD, "api-tenant");
            return ((FodGlobalDescriptor)((Object)GlobalConfiguration.all().get(FodGlobalDescriptor.class))).testConnection(testApi);
        }

        public ListBoxModel doFillEntitlementPreferenceItems() {
            ListBoxModel items = new ListBoxModel();
            for (FodEnums.EntitlementPreferenceType preferenceType : FodEnums.EntitlementPreferenceType.values()) {
                items.add((Object)new ListBoxModel.Option(preferenceType.toString(), String.valueOf(preferenceType.getValue())));
            }
            return items;
        }
    }
}

