/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fodupload;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hudson.ProxyConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.fodupload.models.FodEnums;

public class FodApiConnection {
    private static final int CONNECTION_TIMEOUT = 30;
    private static final int WRITE_TIMEOUT = 30;
    private static final int READ_TIMEOUT = 30;
    public static final int MAX_SIZE = 50;
    private String baseUrl;
    private String apiUrl;
    private OkHttpClient client;
    private String token;
    private FodEnums.GrantType grantType;
    private String scope;
    private String id;
    private String secret;
    private ProxyConfiguration proxy = null;

    FodApiConnection(String id, String secret, String baseUrl, String apiUrl, FodEnums.GrantType grantType, String scope) {
        this.id = id;
        this.secret = secret;
        this.baseUrl = baseUrl;
        this.apiUrl = apiUrl;
        this.grantType = grantType;
        this.scope = scope;
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            this.proxy = instance.proxy;
        }
        this.client = this.Create();
    }

    public void authenticate() throws IOException {
        FormBody formBody = null;
        if (this.grantType == FodEnums.GrantType.CLIENT_CREDENTIALS) {
            formBody = new FormBody.Builder().add("scope", this.scope).add("grant_type", "client_credentials").add("client_id", this.id).add("client_secret", this.secret).build();
        } else if (this.grantType == FodEnums.GrantType.PASSWORD) {
            formBody = new FormBody.Builder().add("scope", this.scope).add("grant_type", "password").add("username", this.id).add("password", this.secret).build();
        } else {
            throw new IOException("Invalid Grant Type");
        }
        Request request = new Request.Builder().url(this.apiUrl + "/oauth/token").post((RequestBody)formBody).build();
        Response response = this.client.newCall(request).execute();
        if (!response.isSuccessful()) {
            throw new IOException("Unexpected code " + response);
        }
        String content = IOUtils.toString((InputStream)response.body().byteStream(), (String)"utf-8");
        response.body().close();
        JsonParser parser = new JsonParser();
        JsonObject obj = parser.parse(content).getAsJsonObject();
        this.token = obj.get("access_token").getAsString();
    }

    void retireToken() throws IOException {
        Request request = new Request.Builder().url(this.apiUrl + "/oauth/retireToken").addHeader("Authorization", "Bearer " + this.token).get().build();
        Response response = this.client.newCall(request).execute();
        if (response.isSuccessful()) {
            response.body().close();
            this.token = null;
        }
    }

    private OkHttpClient Create() {
        OkHttpClient.Builder baseClient = new OkHttpClient().newBuilder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS);
        if (this.proxy == null) {
            return baseClient.build();
        }
        OkHttpClient.Builder proxyClient = baseClient.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxy.name, this.proxy.port)));
        String credentials = Credentials.basic((String)this.proxy.getUserName(), (String)this.proxy.getPassword());
        Authenticator proxyAuthenticator = (route, response) -> response.request().newBuilder().header("Proxy-Authorization", credentials).build();
        proxyClient.proxyAuthenticator(proxyAuthenticator);
        return proxyClient.build();
    }

    public String getToken() {
        return this.token;
    }

    public String getId() {
        return this.id;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public OkHttpClient getClient() {
        return this.client;
    }
}

