/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fortifycloudscan.util;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class CommandUtil {
    private CommandUtil() {
    }

    public static void append(List<String> command, Object confItem, String arg) {
        CommandUtil.append(command, confItem, arg, false);
    }

    public static void append(List<String> command, Object confItem, String arg, boolean concat) {
        boolean value;
        if (confItem == null && arg != null) {
            command.add(arg);
        }
        if (confItem instanceof String) {
            String value2 = (String)confItem;
            if (StringUtils.isNotBlank((String)value2)) {
                if (value2.contains(" ")) {
                    value2 = "\"" + value2 + "\"";
                }
                if (concat) {
                    command.add(arg + value2);
                } else {
                    command.add(arg);
                    command.add(value2);
                }
            }
        } else if (confItem instanceof Boolean && (value = ((Boolean)confItem).booleanValue())) {
            command.add(arg);
        }
    }

    public static String toString(String[] stringArray) {
        StringBuilder sb = new StringBuilder();
        for (String string : stringArray) {
            sb.append(string).append(" ");
        }
        return sb.toString().trim();
    }

    public static String generateShellCommand(String[] command) {
        String shellCommand = SystemUtils.IS_OS_WINDOWS ? "cmd /c " + CommandUtil.toString(command) : "sh -c '" + CommandUtil.toString(command) + "'";
        return shellCommand;
    }
}

