/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fortifycloudscan.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class ArchiveUtil {
    private ArchiveUtil() {
    }

    public static void unzip(File directory, File zipFile) throws IOException {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        byte[] buffer = new byte[2048];
        try (FileInputStream fInput = new FileInputStream(zipFile);
             ZipInputStream zipInput = new ZipInputStream(fInput);){
            ZipEntry entry = zipInput.getNextEntry();
            while (entry != null) {
                String entryName = entry.getName();
                File file = new File(directory.getAbsolutePath() + File.separator + entryName);
                if (entry.isDirectory()) {
                    File newDir = new File(file.getAbsolutePath());
                    if (!newDir.exists()) {
                        newDir.mkdirs();
                    }
                } else {
                    if (!file.getParentFile().isDirectory() && !file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    try (FileOutputStream fOutput = new FileOutputStream(file);){
                        int count;
                        while ((count = zipInput.read(buffer)) > 0) {
                            fOutput.write(buffer, 0, count);
                        }
                    }
                }
                zipInput.closeEntry();
                entry = zipInput.getNextEntry();
            }
            zipInput.closeEntry();
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }
}

