/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fortifycloudscan;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jenkinsci.plugins.fortifycloudscan.ConsoleLogger;
import org.jenkinsci.plugins.fortifycloudscan.util.ArchiveUtil;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class RulepackResolver {
    private transient ConsoleLogger logger;
    private String tempDir;

    public RulepackResolver(ConsoleLogger logger) {
        this.logger = logger;
        this.tempDir = System.getProperty("java.io.tmpdir");
    }

    public File resolve(String location) {
        block3: {
            try {
                URL url = new URL(location);
                File download = this.download(url);
                if (download != null) {
                    return this.extractArchive(download);
                }
            }
            catch (MalformedURLException e) {
                File file = new File(location);
                if (!file.exists()) break block3;
                return file;
            }
        }
        return null;
    }

    private File download(URL url) {
        File downloadedFile;
        CloseableHttpResponse response;
        String urlString = url.toExternalForm();
        File temp = new File(this.tempDir + File.separator + "FortifyCloudScan" + File.separator + UUID.randomUUID());
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(urlString);
        try {
            this.logger.log("Downloading rulepack from " + urlString);
            response = httpclient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                if (temp.mkdirs()) {
                    this.logger.log("Created temporary rulepack download directory");
                }
            } else {
                this.logger.log("ERROR: Remote file cannot be downloaded");
                this.logger.log("ERROR: Status Code: " + response.getStatusLine().getStatusCode() + " - " + response.getStatusLine().getReasonPhrase());
                return null;
            }
            String suggestedFilename = this.getSuggestedFilename((HttpResponse)response);
            String filename = suggestedFilename != null ? suggestedFilename : FilenameUtils.getName((String)urlString);
            downloadedFile = new File(temp + File.separator + filename);
        }
        catch (IOException e) {
            this.logger.log("ERROR: An error occurred while attempting to download rulepack");
            this.logger.log(e.getMessage());
            return null;
        }
        HttpEntity entity = response.getEntity();
        try (FileOutputStream outstream = new FileOutputStream(downloadedFile);){
            if (entity != null) {
                entity.writeTo((OutputStream)outstream);
                this.logger.log("Rulepack saved to " + downloadedFile.getAbsolutePath());
            }
        }
        catch (FileNotFoundException e) {
            this.logger.log("ERROR: The download file location cannot be found");
            this.logger.log(e.getMessage());
        }
        catch (IOException e) {
            this.logger.log("ERROR: An error occurred while saving the rulepack");
            this.logger.log(e.getMessage());
        }
        return downloadedFile;
    }

    private String getSuggestedFilename(HttpResponse response) {
        NameValuePair pair;
        HeaderElement headerElement;
        Header header = response.getFirstHeader("Content-Disposition");
        if (header == null) {
            return null;
        }
        HeaderElement[] headerElements = header.getElements();
        if (headerElements.length > 0 && "attachment".equalsIgnoreCase((headerElement = headerElements[0]).getName()) && (pair = headerElement.getParameterByName("filename")) != null) {
            return pair.getValue();
        }
        return null;
    }

    private boolean isArchive(File file) {
        String filename = FilenameUtils.getName((String)file.getAbsolutePath());
        return FilenameUtils.isExtension((String)filename, (String)"zip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extractArchive(File file) {
        if (!this.isArchive(file)) {
            return file;
        }
        try {
            this.logger.log("Extracting rulepack archive");
            File extractedDir = new File(file.getParentFile().getAbsolutePath());
            ArchiveUtil.unzip(extractedDir, file);
            File file2 = extractedDir;
            return file2;
        }
        catch (FileNotFoundException e) {
            this.logger.log("ERROR: The file to extract could not be found");
            this.logger.log(e.getMessage());
        }
        catch (IOException e) {
            this.logger.log("ERROR: An unknown error occurred while extracting archive");
            this.logger.log(e.getMessage());
        }
        finally {
            if (file.delete()) {
                this.logger.log("Removed original archive");
            }
        }
        return null;
    }

    public void setTempDir(String directory) {
        File file = new File(directory);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.isDirectory()) {
            this.tempDir = directory;
        }
    }
}

