/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fortifycloudscan;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.jenkinsci.plugins.fortifycloudscan.FortifySscClientException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FortifySscClient {
    private URL endpointUrl;
    private String sscToken;
    private String sscUsername;
    private String sscPassword;

    public FortifySscClient(URL endpointUrl, String sscUsername, String sscPassword) {
        this.endpointUrl = endpointUrl;
        this.sscUsername = sscUsername;
        this.sscPassword = sscPassword;
    }

    public FortifySscClient(URL endpointUrl, String sscToken) {
        this.endpointUrl = endpointUrl;
        this.sscToken = sscToken;
    }

    public SOAPMessage createSoapMessage(XmlObject xmlObject) throws SOAPException {
        MessageFactory msgFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = msgFactory.createMessage();
        SOAPPart prt = soapMessage.getSOAPPart();
        SOAPEnvelope env = prt.getEnvelope();
        this.addWssHeader(env);
        SOAPBody soapBody = env.getBody();
        Node node = xmlObject.getDomNode();
        soapBody.addDocument((Document)node);
        return soapMessage;
    }

    private void addWssHeader(SOAPEnvelope envelope) throws SOAPException {
        SOAPHeader header = envelope.getHeader() == null ? envelope.addHeader() : envelope.getHeader();
        if (this.sscToken != null) {
            header.addAttribute(new QName("xmlns:axis2ns2"), "www.fortify.com/schema");
            header.addAttribute(new QName("axis2ns2:token"), this.sscToken);
        }
        SOAPElement security = header.addChildElement("Security", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        SOAPElement usernameToken = security.addChildElement("UsernameToken", "wsse");
        usernameToken.addAttribute(new QName("xmlns:wsu"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        if (this.sscUsername != null) {
            SOAPElement username = usernameToken.addChildElement("Username", "wsse");
            username.addTextNode(this.sscUsername);
        }
        if (this.sscPassword != null) {
            SOAPElement password = usernameToken.addChildElement("Password", "wsse");
            password.setAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            password.addTextNode(this.sscPassword);
        }
    }

    public SOAPMessage callEndpoint(SOAPMessage soapMessage) throws SOAPException, IOException {
        SOAPConnectionFactory fact = SOAPConnectionFactory.newInstance();
        SOAPConnection con = fact.createConnection();
        SOAPMessage response = con.call(soapMessage, (Object)this.endpointUrl);
        con.close();
        return response;
    }

    public <T> T parseMessage(SOAPMessage soapMessage, Class<T> clazz) throws SOAPException, XmlException, NoSuchFieldException, IllegalAccessException, FortifySscClientException {
        XmlObject b = XmlObject.Factory.parse((Node)soapMessage.getSOAPBody().getFirstChild());
        Field typeField = clazz.getDeclaredField("type");
        SchemaType schemaType = (SchemaType)typeField.get(null);
        SOAPFault fault = soapMessage.getSOAPBody().getFault();
        if (fault != null) {
            throw new FortifySscClientException(fault.getFaultString());
        }
        XmlObject c = XmlBeans.getContextTypeLoader().parse(b.getDomNode(), schemaType, null);
        return clazz.cast(c);
    }
}

