/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fortifycloudscan;

import com.fortify.schema.fws.ActiveProjectVersionListRequestDocument;
import com.fortify.schema.fws.ActiveProjectVersionListResponseDocument;
import com.fortify.schema.fws.ProjectListRequestDocument;
import com.fortify.schema.fws.ProjectListResponseDocument;
import com.fortifysoftware.schema.wsTypes.Project;
import com.fortifysoftware.schema.wsTypes.ProjectVersionLite;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.xmlbeans.XmlException;
import org.jenkinsci.plugins.fortifycloudscan.FortifySscClient;
import org.jenkinsci.plugins.fortifycloudscan.FortifySscClientException;

public class FortifySsc {
    FortifySscClient client;

    public FortifySsc(URL url, String token) {
        this.client = new FortifySscClient(url, token);
    }

    public List<Project> getProjects() throws SOAPException, IOException, XmlException, NoSuchFieldException, IllegalAccessException, FortifySscClientException {
        ProjectListRequestDocument requestDocument = ProjectListRequestDocument.Factory.newInstance();
        requestDocument.addNewProjectListRequest();
        SOAPMessage soapRequest = this.client.createSoapMessage(requestDocument);
        SOAPMessage soapResponse = this.client.callEndpoint(soapRequest);
        ProjectListResponseDocument responseDocument = this.client.parseMessage(soapResponse, ProjectListResponseDocument.class);
        ProjectListResponseDocument.ProjectListResponse projectList = responseDocument.getProjectListResponse();
        return Arrays.asList(projectList.getProjectArray());
    }

    public List<ProjectVersionLite> getActiveProjectVersions(long projectId) throws SOAPException, IOException, XmlException, NoSuchFieldException, IllegalAccessException, FortifySscClientException {
        ArrayList<ProjectVersionLite> projectVersions = new ArrayList<ProjectVersionLite>();
        ActiveProjectVersionListRequestDocument requestDocument = ActiveProjectVersionListRequestDocument.Factory.newInstance();
        requestDocument.addNewActiveProjectVersionListRequest();
        SOAPMessage soapRequest = this.client.createSoapMessage(requestDocument);
        SOAPMessage soapResponse = this.client.callEndpoint(soapRequest);
        ActiveProjectVersionListResponseDocument responseDocument = this.client.parseMessage(soapResponse, ActiveProjectVersionListResponseDocument.class);
        ActiveProjectVersionListResponseDocument.ActiveProjectVersionListResponse activeProjectVersions = responseDocument.getActiveProjectVersionListResponse();
        List<ProjectVersionLite> plist = Arrays.asList(activeProjectVersions.getProjectVersionArray());
        for (ProjectVersionLite projectVersion : plist) {
            if (projectVersion.getProjectId() != projectId) continue;
            projectVersions.add(projectVersion);
        }
        return projectVersions;
    }
}

