/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fortifycloudscan;

import hudson.model.TaskListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.fortifycloudscan.ConsoleLogger;
import org.jenkinsci.plugins.fortifycloudscan.Options;
import org.jenkinsci.plugins.fortifycloudscan.RulepackResolver;
import org.jenkinsci.plugins.fortifycloudscan.util.CommandUtil;

public class FortifyCloudScanExecutor
implements Serializable {
    private static final long serialVersionUID = 3595913479313812273L;
    private final transient ConsoleLogger logger;
    private final Options options;

    public FortifyCloudScanExecutor(TaskListener listener, Options options) {
        this.logger = new ConsoleLogger(listener);
        this.options = options;
    }

    public String prepare() {
        ArrayList<String> mergedCommand = new ArrayList<String>();
        mergedCommand.add(this.options.getCommand());
        mergedCommand.addAll(this.options.getArgs());
        mergedCommand.addAll(this.processRules(this.options.getRules(), this.options.getWorkspace()));
        mergedCommand.addAll(this.options.getScanOpts());
        String[] command = mergedCommand.toArray(new String[mergedCommand.size()]);
        return CommandUtil.generateShellCommand(command);
    }

    private List<String> processRules(List<String> rules, String workspace) {
        ArrayList<String> command = new ArrayList<String>();
        RulepackResolver resolver = new RulepackResolver(this.logger);
        for (String rule : rules) {
            File file = resolver.resolve(rule);
            if (file == null) continue;
            CommandUtil.append(command, file.getAbsolutePath(), "-rules");
        }
        return command;
    }
}

