/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.fortifycloudscan;

import com.fortifysoftware.schema.wsTypes.Project;
import com.fortifysoftware.schema.wsTypes.ProjectVersionLite;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jenkins.security.MasterToSlaveCallable;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.fortifycloudscan.ConsoleLogger;
import org.jenkinsci.plugins.fortifycloudscan.FortifyCloudScanExecutor;
import org.jenkinsci.plugins.fortifycloudscan.FortifySsc;
import org.jenkinsci.plugins.fortifycloudscan.Messages;
import org.jenkinsci.plugins.fortifycloudscan.Options;
import org.jenkinsci.plugins.fortifycloudscan.util.CommandUtil;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class FortifyCloudScanBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 5441945995905689815L;
    private final String buildId;
    private final boolean useAutoHeap;
    private final String xmx;
    private final String rmiWorkerMaxHeap;
    private final String buildLabel;
    private final String buildProject;
    private final String buildVersion;
    private final boolean useSsc;
    private final String sscToken;
    private final String upToken;
    private final String versionId;
    private final String scanArgs;
    private final String filter;
    private final boolean noDefaultRules;
    private final boolean disableSourceRendering;
    private final boolean disableSnippets;
    private final boolean quick;
    private final String rules;
    private final boolean useParallelAnalysis;

    @DataBoundConstructor
    public FortifyCloudScanBuilder(String buildId, Boolean useAutoHeap, String xmx, String rmiWorkerMaxHeap, String buildLabel, String buildProject, String buildVersion, Boolean useSsc, String sscToken, String upToken, String versionId, String scanArgs, String filter, Boolean noDefaultRules, Boolean disableSourceRendering, Boolean disableSnippets, Boolean quick, String rules, Boolean useParallelAnalysis) {
        this.buildId = buildId;
        boolean bl = this.useAutoHeap = useAutoHeap != null && useAutoHeap == false;
        if (this.useAutoHeap) {
            this.xmx = null;
            this.rmiWorkerMaxHeap = null;
        } else {
            this.xmx = xmx;
            this.rmiWorkerMaxHeap = rmiWorkerMaxHeap;
        }
        this.buildLabel = buildLabel;
        this.buildProject = buildProject;
        this.buildVersion = buildVersion;
        this.useSsc = useSsc != null && useSsc != false;
        this.sscToken = sscToken;
        this.upToken = upToken;
        this.versionId = versionId;
        this.scanArgs = scanArgs;
        this.filter = filter;
        this.noDefaultRules = noDefaultRules != null && noDefaultRules != false;
        this.disableSourceRendering = disableSourceRendering != null && disableSourceRendering != false;
        this.disableSnippets = disableSnippets != null && disableSnippets != false;
        this.quick = quick != null && quick != false;
        this.rules = rules;
        this.useParallelAnalysis = useParallelAnalysis != null && useParallelAnalysis != false;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public boolean getUseAutoHeap() {
        return this.useAutoHeap;
    }

    public String getXmx() {
        return this.xmx;
    }

    public String getRmiWorkerMaxHeap() {
        return this.rmiWorkerMaxHeap;
    }

    public String getBuildLabel() {
        return this.buildLabel;
    }

    public String getBuildProject() {
        return this.buildProject;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public boolean getUseSsc() {
        return this.useSsc;
    }

    public String getSscToken() {
        return this.sscToken;
    }

    public String getUpToken() {
        return this.upToken;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getScanArgs() {
        return this.scanArgs;
    }

    public String getFilter() {
        return this.filter;
    }

    public Boolean getNoDefaultRules() {
        return this.noDefaultRules;
    }

    public Boolean getDisableSourceRendering() {
        return this.disableSourceRendering;
    }

    public Boolean getDisableSnippets() {
        return this.disableSnippets;
    }

    public Boolean getQuick() {
        return this.quick;
    }

    public String getRules() {
        return this.rules;
    }

    public Boolean getUseParallelAnalysis() {
        return this.useParallelAnalysis;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath filePath, @Nonnull Launcher launcher, final @Nonnull TaskListener listener) throws InterruptedException, IOException {
        ConsoleLogger logger = new ConsoleLogger(listener);
        if (this.useSsc && StringUtils.isBlank((String)this.getDescriptor().sscUrl)) {
            logger.log(Messages.unspecifiedUrl_ssc());
            build.setResult(Result.FAILURE);
            return;
        }
        if (!this.useSsc && StringUtils.isBlank((String)this.getDescriptor().controllerUrl)) {
            logger.log(Messages.unspecifiedUrl_controller());
            build.setResult(Result.FAILURE);
            return;
        }
        final Options options = new Options();
        options.setEnvVars((Map)build.getEnvironment(listener));
        options.setCommand(this.generateCommand(build, listener));
        options.setArgs(this.generateArgs(build, listener));
        options.setRules(this.preProcessRules(build, listener));
        options.setScanOpts(this.generateScanOptions(build, listener));
        options.setWorkspace(filePath.getRemote());
        EnvVars env = build.getEnvironment(listener);
        String command = (String)launcher.decorateByEnv(env).getChannel().call((Callable)new MasterToSlaveCallable<String, IOException>(){

            public String call() throws IOException {
                FortifyCloudScanExecutor executor = new FortifyCloudScanExecutor(listener, options);
                return executor.prepare();
            }
        });
        String versionCommand = (String)launcher.decorateByEnv(env).getChannel().call((Callable)new MasterToSlaveCallable<String, IOException>(){

            public String call() throws IOException {
                return CommandUtil.generateShellCommand(new String[]{options.getCommand(), "-version"});
            }
        });
        launcher.launch().cmdAsSingleString(versionCommand).envs((Map)env).stdout((OutputStream)((Object)logger)).start().join();
        if (launcher.launch().cmdAsSingleString(command).envs((Map)env).stdout((OutputStream)((Object)logger)).start().join() == 0) {
            build.setResult(Result.SUCCESS);
        } else {
            build.setResult(Result.FAILURE);
        }
    }

    private String generateCommand(Run<?, ?> build, TaskListener listener) {
        String exePath = this.substituteVariable(build, listener, this.getDescriptor().getExePath());
        if (StringUtils.isNotBlank((String)exePath)) {
            return exePath;
        }
        return "cloudscan";
    }

    private List<String> generateArgs(Run<?, ?> build, TaskListener listener) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.useSsc) {
            CommandUtil.append(args, this.substituteVariable(build, listener, this.getDescriptor().getSscUrl()), "-sscurl");
            CommandUtil.append(args, this.substituteVariable(build, listener, this.sscToken), "-ssctoken");
            CommandUtil.append(args, null, "start");
            CommandUtil.append(args, null, "-upload");
            CommandUtil.append(args, this.substituteVariable(build, listener, this.versionId), "-versionid");
            CommandUtil.append(args, this.substituteVariable(build, listener, this.upToken), "-uptoken");
        } else {
            CommandUtil.append(args, this.substituteVariable(build, listener, this.getDescriptor().getControllerUrl()), "-url");
            CommandUtil.append(args, null, "start");
        }
        CommandUtil.append(args, this.substituteVariable(build, listener, this.buildId), "-b");
        CommandUtil.append(args, this.substituteVariable(build, listener, this.filter), "-filter");
        return args;
    }

    private List<String> preProcessRules(Run<?, ?> build, TaskListener listener) {
        String[] paths = this.rules.split("\t|\n|\r|,");
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = this.substituteVariable(build, listener, paths[i]);
        }
        return Arrays.asList(paths);
    }

    private List<String> generateScanOptions(Run<?, ?> build, TaskListener listener) {
        ArrayList<String> scanOptions = new ArrayList<String>();
        CommandUtil.append(scanOptions, null, "-scan");
        if (this.useAutoHeap) {
            CommandUtil.append(scanOptions, this.useAutoHeap, "-autoheap");
        } else {
            CommandUtil.append(scanOptions, this.substituteVariable(build, listener, this.xmx), "-Xmx", true);
            CommandUtil.append(scanOptions, this.substituteVariable(build, listener, this.rmiWorkerMaxHeap), "-Dcom.fortify.sca.RmiWorkerMaxHeap=", true);
        }
        CommandUtil.append(scanOptions, this.noDefaultRules, "-no-default-rules");
        CommandUtil.append(scanOptions, this.substituteVariable(build, listener, this.buildLabel), "-build-label");
        CommandUtil.append(scanOptions, this.substituteVariable(build, listener, this.buildProject), "-build-project");
        CommandUtil.append(scanOptions, this.substituteVariable(build, listener, this.buildVersion), "-build-version");
        CommandUtil.append(scanOptions, this.disableSourceRendering, "-disable-source-rendering");
        CommandUtil.append(scanOptions, this.disableSnippets, "-Dcom.fortify.sca.FVDLDisableSnippets=true");
        CommandUtil.append(scanOptions, this.quick, "-quick");
        CommandUtil.append(scanOptions, this.useParallelAnalysis, "-mt");
        CommandUtil.append(scanOptions, null, this.substituteVariable(build, listener, this.scanArgs));
        return scanOptions;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    protected String substituteVariable(Run<?, ?> build, TaskListener listener, String parameterizedValue) {
        if (!(build instanceof AbstractBuild)) {
            return parameterizedValue;
        }
        try {
            if (parameterizedValue != null && parameterizedValue.contains("${")) {
                int start = parameterizedValue.indexOf("${");
                int end = parameterizedValue.indexOf("}", start);
                String parameter = parameterizedValue.substring(start + 2, end);
                String value = (String)build.getEnvironment(listener).get((Object)parameter);
                if (value == null) {
                    throw new IllegalStateException(parameter);
                }
                String substitutedValue = parameterizedValue.substring(0, start) + value + (parameterizedValue.length() > end + 1 ? parameterizedValue.substring(end + 1) : "");
                if (end > 0) {
                    return this.substituteVariable(build, listener, substitutedValue);
                }
                return parameterizedValue;
            }
            return parameterizedValue;
        }
        catch (IOException | InterruptedException e) {
            return parameterizedValue;
        }
    }

    @Extension
    @Symbol(value={"fortifyCloudScan"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String exePath;
        private String sscUrl;
        private String controllerUrl;
        private String globalSscToken;
        private static final Pattern PATTERN_VERSION_ID = Pattern.compile("^[0-9]{5}?$");
        private static final Pattern PATTERN_UUID = Pattern.compile("^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$");
        private static final Pattern PATTERN_MEMORY = Pattern.compile("^[0-9]*(g|G|m|M)$");

        public DescriptorImpl() {
            super(FortifyCloudScanBuilder.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.Builder_Name();
        }

        public FormValidation doCheckSscUrl(@QueryParameter String value) {
            return this.checkUrl(value);
        }

        public FormValidation doCheckControllerUrl(@QueryParameter String value) {
            return this.checkUrl(value);
        }

        public FormValidation doCheckExePath(@QueryParameter String value) {
            return this.checkPath(value);
        }

        private FormValidation checkUrl(String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            try {
                new URL(value);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"The specified value is not a valid URL");
            }
            return FormValidation.ok();
        }

        private FormValidation checkPath(String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.ok();
            }
            try {
                FilePath filePath = new FilePath(new File(value));
                filePath.exists();
            }
            catch (Exception e) {
                return FormValidation.error((String)"The specified value is not a valid path");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckXmx(@QueryParameter String value) {
            if (PATTERN_MEMORY.matcher(value).matches()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Xmx is not in the correct format.");
        }

        public FormValidation doCheckUpToken(@QueryParameter String value) {
            return this.checkToken(value);
        }

        public FormValidation doCheckSscToken(@QueryParameter String value) {
            return this.checkToken(value);
        }

        private FormValidation checkToken(String value) {
            if (PATTERN_UUID.matcher(value).matches()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Token is not in the correct format.");
        }

        public FormValidation doCheckVersionId(@QueryParameter String value) {
            if (PATTERN_VERSION_ID.matcher(value).matches()) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Project Version ID not in the correct format.");
        }

        public ListBoxModel doFillProjectItems() {
            if (StringUtils.isBlank((String)this.sscUrl) || StringUtils.isBlank((String)this.globalSscToken)) {
                return null;
            }
            ListBoxModel m = new ListBoxModel();
            try {
                FortifySsc ssc = new FortifySsc(new URL(this.sscUrl + "/fm-ws/services"), this.globalSscToken);
                List<Project> projects = ssc.getProjects();
                m.add("---- " + Messages.select() + " ---- ", "");
                for (Project project : projects) {
                    m.add(project.getName(), String.valueOf(project.getId()));
                }
            }
            catch (Exception e) {
                m.add(Messages.sscfailure(), e.getMessage());
            }
            return m;
        }

        public ListBoxModel doFillProjectVersionItems(@QueryParameter String project) {
            if (StringUtils.isBlank((String)this.sscUrl) || StringUtils.isBlank((String)this.globalSscToken)) {
                return null;
            }
            ListBoxModel m = new ListBoxModel();
            if (project == null || project.equals("")) {
                m.add("", "");
                return m;
            }
            try {
                FortifySsc ssc = new FortifySsc(new URL(this.sscUrl + "/fm-ws/services"), this.globalSscToken);
                List<ProjectVersionLite> projectVersions = ssc.getActiveProjectVersions(Long.parseLong(project));
                m.add("---- " + Messages.select() + " ---- ", "");
                for (ProjectVersionLite projectVersion : projectVersions) {
                    m.add(projectVersion.getName(), String.valueOf(projectVersion.getId()));
                }
            }
            catch (Exception e) {
                m.add(Messages.sscfailure(), e.getMessage());
            }
            return m;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.exePath = formData.getString("exePath");
            this.sscUrl = formData.getString("sscUrl").replaceAll("/$", "");
            this.controllerUrl = formData.getString("controllerUrl").replaceAll("/$", "");
            this.globalSscToken = formData.getString("globalSscToken");
            this.save();
            return super.configure(req, formData);
        }

        public String getExePath() {
            return this.exePath;
        }

        public String getSscUrl() {
            return this.sscUrl;
        }

        public String getControllerUrl() {
            return this.controllerUrl;
        }

        public String getGlobalSscToken() {
            return this.globalSscToken;
        }
    }
}

