/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.fogbugz.jobpoller;

import antlr.ANTLRException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.triggers.TimerTrigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.fogbugz.jobtrigger.FogbugzEventListener;
import jenkins.plugins.fogbugz.notifications.FogbugzNotifier;
import org.kohsuke.stapler.DataBoundConstructor;
import org.paylogic.fogbugz.FogbugzCase;
import org.paylogic.fogbugz.FogbugzManager;
import org.paylogic.fogbugz.FogbugzUser;
import org.paylogic.fogbugz.InvalidResponseException;
import org.paylogic.fogbugz.NoSuchCaseException;

public class FogbugzStatePoller
extends TimerTrigger {
    private static final Logger log = Logger.getLogger(FogbugzStatePoller.class.getName());
    public final String ciProject;
    public final String ciProjectField;

    @DataBoundConstructor
    public FogbugzStatePoller(String spec, String ciProject, String ciProjectField) throws ANTLRException {
        super(spec);
        this.ciProject = ciProject;
        this.ciProjectField = ciProjectField;
    }

    public void run() {
        log.info("Running FogbugzStatePoller for project " + this.ciProject + ".");
        FogbugzNotifier fb = new FogbugzNotifier();
        FogbugzManager fbManager = fb.getFogbugzManager();
        FogbugzEventListener fbListener = new FogbugzEventListener();
        this.doRun(fb, fbManager, fbListener);
    }

    public void doRun(FogbugzNotifier fb, FogbugzManager fbManager, FogbugzEventListener fbListener) {
        List cases;
        FogbugzUser user = fbManager.getFogbugzUser(fbManager.getMergekeeperUserId());
        try {
            String query = "%s:\"%s\" assignedto:\"%s\"";
            query = String.format(query, this.ciProjectField, this.ciProject, user.name);
            cases = fbManager.searchForCases(query);
        }
        catch (InvalidResponseException e) {
            log.log(Level.SEVERE, "FogbugzStatePoller encountered an error while getting project list.");
            log.log(Level.SEVERE, e.getMessage());
            return;
        }
        catch (NoSuchCaseException e) {
            log.info("FogbugzStatePoller found no cases, not running.");
            return;
        }
        for (FogbugzCase cs : cases) {
            Job job = (Job)this.job;
            int case_id = cs.getId();
            String case_id_string = case_id + "";
            if (job.isBuilding()) {
                try {
                    EnvVars vars = job.getLastBuild().getEnvironment((TaskListener)new LogTaskListener(log, Level.INFO));
                    if (vars.get("CASE_ID", "").trim().equals(case_id_string)) {
                        continue;
                    }
                }
                catch (InterruptedException exc) {
                }
                catch (IOException exc) {
                    // empty catch block
                }
            }
            fbListener.scheduleJob(fb, case_id, job.getName(), null, null, false);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return true;
        }

        public String getDisplayName() {
            return "Poll Fogbugz for cases waiting for mergekeepering.";
        }
    }
}

