/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.fogbugz.casecreator;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.fogbugz.notifications.FogbugzNotifier;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.paylogic.fogbugz.FogbugzCase;
import org.paylogic.fogbugz.FogbugzManager;

public class FogbugzCaseCreator
extends Notifier {
    private static final Logger log = Logger.getLogger(FogbugzCaseCreator.class.getName());

    @DataBoundConstructor
    public FogbugzCaseCreator() {
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        try {
            FogbugzCase fbCase;
            FogbugzNotifier notifier;
            FogbugzManager caseManager;
            boolean fbResult;
            AbstractTestResultAction resultAction = (AbstractTestResultAction)build.getAction(AbstractTestResultAction.class);
            if (resultAction == null) {
                return true;
            }
            int currentFailingTests = resultAction.getFailCount();
            int previousFailingTests = ((AbstractTestResultAction)build.getPreviousBuild().getAction(AbstractTestResultAction.class)).getFailCount();
            boolean newFailedTests = false;
            ArrayList<String> newFailingTestsList = new ArrayList<String>();
            for (Object cr : ((AbstractTestResultAction)build.getAction(AbstractTestResultAction.class)).getFailedTests()) {
                CaseResult rr = (CaseResult)cr;
                if (!rr.isFailed() || rr.getPreviousResult().isFailed()) continue;
                newFailedTests = true;
                newFailingTestsList.add(rr.getName());
            }
            if (newFailedTests && !(fbResult = (caseManager = (notifier = new FogbugzNotifier()).getFogbugzManager()).saveCase(fbCase = new FogbugzCase(0, String.format("New failing tests in Jenkins job '%s'", build.getProject().getName()), notifier.getDescriptor().getMergekeeperUserId(), notifier.getDescriptor().getMergekeeperUserId(), "autocreated", true, "", "", "", "", "", ""), String.format("Job '%s' has %d more failing tests than the previous build.\nNew failing tests:\n%s\nView complete result here: %s.", build.getProject().getName(), currentFailingTests - previousFailingTests, StringUtils.join(newFailingTestsList, (String)",\n"), build.getAbsoluteUrl())))) {
                log.log(Level.SEVERE, "Something went wrong while creating a new case.");
            }
        }
        catch (Exception e) {
            log.log(Level.INFO, "Exception in FogbugzCaseCreator.", e);
        }
        return true;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Create new FogBugz case on new test failures.";
        }
    }
}

