/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.fogbugz.buildwrappers;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.plugins.fogbugz.notifications.FogbugzNotifier;
import org.kohsuke.stapler.DataBoundConstructor;
import org.paylogic.fogbugz.FogbugzCase;
import org.paylogic.fogbugz.FogbugzManager;

public class FogbugzEnvironmentWrapper
extends BuildWrapper {
    private static final Logger log = Logger.getLogger(FogbugzEnvironmentWrapper.class.getName());
    private Pattern BRANCH_URL_PATTERN = Pattern.compile("^(?<vcs>\\w+\\+)?(?<url>.+)#(?<branch>.+)");
    private final boolean copyInformation;
    private final String repoBase;

    @DataBoundConstructor
    public FogbugzEnvironmentWrapper(boolean copyInformation, String repoBase) {
        this.copyInformation = copyInformation;
        this.repoBase = repoBase;
    }

    public String parseRepoUrl(String featureBranchField) throws Exception {
        String repoBase = this.getRepoBase();
        URI baseRepoUrl = new URI(repoBase);
        Matcher matcher = this.BRANCH_URL_PATTERN.matcher(featureBranchField);
        matcher.matches();
        matcher.group();
        boolean fullURL = false;
        featureBranchField = matcher.group("url");
        try {
            URI featureRepoUrl = new URI(featureBranchField);
            URI res = baseRepoUrl.resolve(featureRepoUrl);
            if (!fullURL && (repoBase.contains(baseRepoUrl.getHost() + "//") || featureBranchField.toString().contains(featureRepoUrl.getHost() + "//"))) {
                return res.toString().replace(res.getHost() + "/", res.getHost() + "//").replace("///", "//");
            }
            return res.toString();
        }
        catch (URISyntaxException exception) {
            return featureBranchField;
        }
    }

    public static String parseBranchName(String branchExpression) {
        String[] parts = branchExpression.split("#");
        if (parts.length > 1) {
            return parts[parts.length - 1];
        }
        return branchExpression;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) {
        EnvVars currentEnv;
        final EnvVars envVars = new EnvVars();
        try {
            currentEnv = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Failure while retrieving existing environment for build.", e);
            return null;
        }
        int caseId = Integer.parseInt(currentEnv.get("CASE_ID", ""));
        FogbugzManager manager = new FogbugzNotifier().getFogbugzManager();
        FogbugzCase fbCase = null;
        try {
            fbCase = manager.getCaseById(caseId);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Exception while fetching case from Fogbugz", e);
            return null;
        }
        try {
            String repoUrl = this.parseRepoUrl(fbCase.getFeatureBranch());
            envVars.put("REPO_URL", repoUrl);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Error while parsing repo url, not continuing with build", e);
            return null;
        }
        envVars.put("TARGET_BRANCH", FogbugzEnvironmentWrapper.parseBranchName(fbCase.getTargetBranch()));
        envVars.put("ORIGINAL_BRANCH", FogbugzEnvironmentWrapper.parseBranchName(fbCase.getOriginalBranch()));
        envVars.put("FEATURE_BRANCH", FogbugzEnvironmentWrapper.parseBranchName(fbCase.getFeatureBranch()));
        envVars.put("APPROVED_REVISION", fbCase.getApprovedRevision());
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                env.putAll((Map<String, String>)envVars);
            }
        };
    }

    public boolean isCopyInformation() {
        return this.copyInformation;
    }

    public String getRepoBase() {
        return this.repoBase;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "Copy custom fields from Fogbugz case retrieved by 'CASE_ID' environment variable into environment variables available to other build steps.";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

