/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.fogbugz;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class FogbugzProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(FogbugzProjectProperty.class.getName());
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private String regex;
        private String url;

        public DescriptorImpl() {
            super(FogbugzProjectProperty.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return false;
        }

        public String getDisplayName() {
            return "Fogbugz case annotator";
        }

        public FogbugzProjectProperty newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new FogbugzProjectProperty();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.regex = req.getParameter("fogbugz.regex");
            this.url = req.getParameter("fogbugz.url");
            this.save();
            return true;
        }

        public String getUrl() {
            if (this.url == null) {
                return "http://fogbugz/";
            }
            return this.url;
        }

        public String getRegex() {
            if (this.regex == null) {
                return "CASE-([0-9]*)";
            }
            return this.regex;
        }

        public FormValidation doRegexCheck(@QueryParameter(fixEmpty=true) String value) {
            if (value == null) {
                return FormValidation.error((String)"No Case ID regex");
            }
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)"Pattern cannot be compiled");
            }
        }

        public FormValidation doUrlCheck(final @QueryParameter(fixEmpty=true) String value) throws IOException, ServletException {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String url = Util.fixEmpty((String)value);
                    if (url == null) {
                        return FormValidation.error((String)"URL cannot be null");
                    }
                    try {
                        if (!this.findText(this.open(new URL(url)), "FogBugz")) {
                            return FormValidation.error((String)"This is a valid URL but it doesn't look like FogBugz");
                        }
                        return FormValidation.ok();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Unable to connect to " + url, e);
                        return this.handleIOException(url, e);
                    }
                }
            }.check();
        }
    }
}

