/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.fogbugz;

import hudson.Extension;
import hudson.MarkupText;
import hudson.model.AbstractBuild;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.plugins.fogbugz.FogbugzProjectProperty;

@Extension
public class FogbugzChangelogAnnotator
extends ChangeLogAnnotator {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static final String VIEW_CASE_URL = "/default.asp?";

    public void annotate(AbstractBuild<?, ?> build, ChangeLogSet.Entry change, MarkupText text) {
        Pattern pattern = null;
        String regex = FogbugzProjectProperty.DESCRIPTOR.getRegex();
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            this.logger.log(Level.WARNING, "Cannot compile pattern: {0}", regex);
            return;
        }
        for (MarkupText.SubText token : text.findTokens(pattern)) {
            try {
                Integer key = this.getId(token);
                token.surroundWith(String.format("<a href='%s%s%d'>", FogbugzProjectProperty.DESCRIPTOR.getUrl(), VIEW_CASE_URL, key), "</a>");
            }
            catch (Exception e) {}
        }
    }

    private int getId(MarkupText.SubText token) {
        int i = 0;
        while (true) {
            String id = token.group(i);
            try {
                return Integer.valueOf(id);
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.FINE, "{0} is not a number in group {1}, trying next group", new Object[]{id, i});
                ++i;
                continue;
            }
            break;
        }
    }
}

