/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.flexible_publish;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.jenkins_ci.plugins.flexible_publish.FlexiblePublisher;
import org.jenkins_ci.plugins.flexible_publish.Messages;
import org.jenkins_ci.plugins.flexible_publish.PublisherDescriptorLister;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPublisherDescriptorLister
implements PublisherDescriptorLister {
    @DataBoundConstructor
    public DefaultPublisherDescriptorLister() {
    }

    @Override
    public List<? extends Descriptor<? extends BuildStep>> getAllowedPublishers() {
        ArrayList<BuildStepDescriptor> publishers = new ArrayList<BuildStepDescriptor>();
        AbstractProject project = (AbstractProject)Stapler.getCurrentRequest().findAncestorObject(AbstractProject.class);
        for (Descriptor descriptor : Publisher.all()) {
            if (descriptor instanceof FlexiblePublisher.FlexiblePublisherDescriptor || !(descriptor instanceof BuildStepDescriptor)) continue;
            BuildStepDescriptor buildStepDescriptor = (BuildStepDescriptor)descriptor;
            if (project == null || !buildStepDescriptor.isApplicable(project.getClass()) || !this.hasDbc(buildStepDescriptor.clazz)) continue;
            publishers.add(buildStepDescriptor);
        }
        return publishers;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
    }

    private boolean hasDbc(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (!constructor.isAnnotationPresent(DataBoundConstructor.class)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<PublisherDescriptorLister> {
        public String getDisplayName() {
            return Messages.defaultPublisherDescriptor_displayName();
        }
    }
}

