/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.flexible_publish;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.tasks.BuildStep;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jenkins_ci.plugins.flexible_publish.FlexiblePublisher;
import org.jenkins_ci.plugins.run_condition.BuildStepRunner;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalPublisher
implements Describable<ConditionalPublisher> {
    private final RunCondition condition;
    private final BuildStep publisher;
    private BuildStepRunner runner;

    @DataBoundConstructor
    public ConditionalPublisher(RunCondition condition, BuildStep publisher, BuildStepRunner runner) {
        this.condition = condition;
        this.publisher = publisher;
        this.runner = runner;
    }

    public RunCondition getCondition() {
        return this.condition;
    }

    public BuildStep getPublisher() {
        return this.publisher;
    }

    public BuildStepRunner getRunner() {
        return this.runner;
    }

    public ConditionalPublisherDescriptor getDescriptor() {
        return (ConditionalPublisherDescriptor)Hudson.getInstance().getDescriptorByType(ConditionalPublisherDescriptor.class);
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return this.publisher.getProjectActions(project);
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        return this.runner.prebuild(this.condition, this.publisher, build, listener);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this.runner.perform(this.condition, this.publisher, build, launcher, listener);
    }

    public Object readResolve() {
        if (this.runner == null) {
            this.runner = new BuildStepRunner.Fail();
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class ConditionalPublisherDescriptor
    extends Descriptor<ConditionalPublisher> {
        public String getDisplayName() {
            return "Never seen - one hopes :-)";
        }

        public DescriptorExtensionList<BuildStepRunner, BuildStepRunner.BuildStepRunnerDescriptor> getBuildStepRunners() {
            return BuildStepRunner.all();
        }

        public List<? extends Descriptor<? extends RunCondition>> getRunConditions() {
            return RunCondition.all();
        }

        public List<? extends Descriptor<? extends BuildStep>> getAllowedPublishers() {
            return ((FlexiblePublisher.FlexiblePublisherDescriptor)Hudson.getInstance().getDescriptorByType(FlexiblePublisher.FlexiblePublisherDescriptor.class)).getPublisherLister().getAllowedPublishers();
        }
    }
}

