/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.flakyTestHandler.plugin.deflake;

import com.google.jenkins.flakyTestHandler.plugin.deflake.DeflakeCause;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;

public class DeflakeGitBuildChooser
extends BuildChooser {
    private final DefaultBuildChooser defaultBuildChooser = new DefaultBuildChooser();

    @DataBoundConstructor
    public DeflakeGitBuildChooser() {
    }

    public Collection<Revision> getCandidateRevisions(boolean isPollCall, String singleBranch, GitClient git, TaskListener listener, BuildData buildData, BuildChooserContext context) throws GitException, IOException, InterruptedException {
        BuildData gitBuildData;
        Revision revision;
        AbstractBuild build = (AbstractBuild)context.actOnBuild((BuildChooserContext.ContextCallable)new GetBuild());
        DeflakeCause cause = (DeflakeCause)build.getCause(DeflakeCause.class);
        if (cause != null && (revision = (gitBuildData = this.gitSCM.getBuildData(cause.getUpstreamRun(), true)).getLastBuiltRevision()) != null) {
            return Collections.singletonList(revision);
        }
        this.defaultBuildChooser.gitSCM = this.gitSCM;
        return this.defaultBuildChooser.getCandidateRevisions(isPollCall, singleBranch, git, listener, buildData, context);
    }

    private static class GetBuild
    implements BuildChooserContext.ContextCallable<AbstractBuild<?, ?>, AbstractBuild> {
        private GetBuild() {
        }

        public AbstractBuild invoke(AbstractBuild<?, ?> build, VirtualChannel channel) {
            return build;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildChooserDescriptor {
        public String getDisplayName() {
            return "Checkout failing revision when deflaking";
        }
    }
}

