/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.extremefeedback.model;

import hudson.model.Result;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.extremefeedback.Lamps;
import org.jenkinsci.plugins.extremefeedback.model.JenkinsEvent;
import org.jenkinsci.plugins.extremefeedback.model.Lamp;
import org.jenkinsci.plugins.extremefeedback.model.States;

public class XfEventMessage {
    public void sendBuzzerMessage(Lamp lamp) {
        String eventMessage = this.buildBuzzerJson(lamp);
        this.sendEventMessage(eventMessage);
    }

    public void sendColorMessage(Lamp lamp, Result result, States.Action action) {
        String eventMessage = this.buildColorJson(States.resultColorMap.get(result).toString(), lamp, action.equals((Object)States.Action.FLASHING));
        this.sendEventMessage(eventMessage);
    }

    public void sendSfxMessage(Lamp lamp, Result result) {
        String eventMessage = this.buildSfxJson(States.resultColorMap.get(result).toString(), lamp);
        this.sendEventMessage(eventMessage);
    }

    public void sendLCDMessage(Lamp lamp, String lcdText) {
        String eventMessage = this.buildLCDJson(lamp, lcdText);
        this.sendEventMessage(eventMessage);
    }

    private String buildBuzzerJson(Lamp lamp) {
        JSONObject jsonBuzzer = new JSONObject();
        jsonBuzzer.accumulate("macAddress", (Object)lamp.getMacAddress());
        jsonBuzzer.accumulate("type", (Object)Type.buzzer);
        jsonBuzzer.accumulate("name", (Object)(lamp.getName() != null ? lamp.getName() : lamp.getMacAddress()));
        return jsonBuzzer.toString();
    }

    private String buildColorJson(String color, Lamp lamp, boolean flashing) {
        JSONObject jsonColor = new JSONObject();
        jsonColor.accumulate("macAddress", (Object)lamp.getMacAddress());
        jsonColor.accumulate("type", (Object)Type.color);
        jsonColor.accumulate("color", (Object)color);
        jsonColor.accumulate("flashing", flashing);
        jsonColor.accumulate("name", (Object)(lamp.getName() != null ? lamp.getName() : lamp.getMacAddress()));
        return jsonColor.toString();
    }

    private String buildSfxJson(String color, Lamp lamp) {
        JSONObject jsonSfx = new JSONObject();
        jsonSfx.accumulate("macAddress", (Object)lamp.getMacAddress());
        jsonSfx.accumulate("type", (Object)Type.soundalarm);
        jsonSfx.accumulate("color", (Object)color);
        jsonSfx.accumulate("name", (Object)(lamp.getName() != null ? lamp.getName() : lamp.getMacAddress()));
        return jsonSfx.toString();
    }

    private String buildLCDJson(Lamp lamp, String lcdText) {
        JSONObject jsonLcd = new JSONObject();
        jsonLcd.accumulate("macAddress", (Object)lamp.getMacAddress());
        jsonLcd.accumulate("type", (Object)Type.lcdtext);
        jsonLcd.accumulate("text", (Object)lcdText);
        jsonLcd.accumulate("name", (Object)(lamp.getName() != null ? lamp.getName() : lamp.getMacAddress()));
        return jsonLcd.toString();
    }

    private void sendEventMessage(String message) {
        Lamps plugin = Lamps.getInstance();
        plugin.getEventBus().post((Object)new JenkinsEvent(message));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        buzzer,
        color,
        soundalarm,
        lcdtext;

    }
}

