/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.extremefeedback;

import com.google.common.eventbus.Subscribe;
import hudson.Extension;
import hudson.cli.CLICommand;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jenkinsci.plugins.extremefeedback.Lamps;
import org.jenkinsci.plugins.extremefeedback.model.JenkinsEvent;

@Extension
public class EventStreamCommand
extends CLICommand {
    private Queue<String> events = new LinkedBlockingQueue<String>();

    public EventStreamCommand() {
        Lamps plugin = Lamps.getInstance();
        plugin.getEventBus().register((Object)this);
    }

    public String getShortDescription() {
        return "xf-event-stream";
    }

    public String getName() {
        return "xf-events";
    }

    @Subscribe
    public void listenEvents(JenkinsEvent event) {
        this.events.add(event.getJson());
    }

    protected int run() throws Exception {
        boolean flag = true;
        while (flag) {
            String event = this.events.poll();
            if (event != null) {
                try {
                    this.stdout.println(event);
                    this.stdout.flush();
                }
                catch (Exception e) {
                    flag = false;
                }
            }
            if (!this.events.isEmpty()) continue;
            Thread.sleep(100L);
        }
        return 0;
    }
}

