/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.extremefeedback.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.extremefeedback.model.Lamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LampFinderCallable
implements Callable<TreeSet<Lamp>> {
    TreeSet<Lamp> lamps = Sets.newTreeSet();
    private static final int PORT = 19418;
    private static final byte[] MESSAGE = "GITGEAR.COM".getBytes();
    private static final Logger LOGGER = Logger.getLogger("jenkins.plugins.extremefeedback");

    @Override
    public TreeSet<Lamp> call() throws Exception {
        MulticastSocket mcs = new MulticastSocket(19419);
        InetAddress inetAddress = InetAddress.getByName("239.77.124.213");
        mcs.send(new DatagramPacket(MESSAGE, MESSAGE.length, inetAddress, 19418));
        mcs.joinGroup(inetAddress);
        mcs.setSoTimeout(5000);
        boolean exit = false;
        while (!exit) {
            byte[] buf = new byte[1000];
            DatagramPacket receiver = new DatagramPacket(buf, buf.length);
            try {
                mcs.receive(receiver);
                String data = new String(receiver.getData());
                LOGGER.log(Level.INFO, data);
                if (!data.startsWith("MAC=")) continue;
                String macAddress = LampFinderCallable.extractMacAddress(data);
                String ipAddress = receiver.getAddress().getHostAddress();
                LOGGER.log(Level.INFO, "MAC Address: " + macAddress + " IP  Address: " + ipAddress);
                Lamp lamp = new Lamp(macAddress, ipAddress);
                this.lamps.add(lamp);
            }
            catch (SocketTimeoutException e) {
                exit = true;
            }
        }
        mcs.leaveGroup(inetAddress);
        return this.lamps;
    }

    @VisibleForTesting
    public static String extractMacAddress(String data) {
        Iterable splitted = Splitter.on((String)"=").trimResults(CharMatcher.noneOf((CharSequence)"0123456789abfcefABCDEF")).split((CharSequence)data);
        return (String)Iterables.get((Iterable)splitted, (int)1);
    }
}

