/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.extracolumns;

import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import jenkins.plugins.extracolumns.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class DescriptionColumn
extends ListViewColumn {
    private boolean displayName;
    private boolean trim;
    private int displayLength;
    private int columnWidth;
    private boolean forceWidth;
    private static final String SEPARATOR = "<br/>";
    private static final String SEPARATORS_REGEX = "(?i)<br\\s*/>|<br>";

    @DataBoundConstructor
    public DescriptionColumn(boolean displayName, boolean trim, int displayLength, int columnWidth, boolean forceWidth) {
        this.displayName = displayName;
        this.trim = trim;
        this.displayLength = displayLength;
        this.columnWidth = columnWidth;
        this.forceWidth = forceWidth;
    }

    public DescriptionColumn() {
        this(false, false, 1, 80, false);
    }

    public boolean isDisplayName() {
        return this.displayName;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public int getDisplayLength() {
        return this.displayLength;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public boolean isForceWidth() {
        return this.forceWidth;
    }

    public String getToolTip(AbstractItem job) {
        return this.formatDescription(job, false);
    }

    public String getDescription(AbstractItem job) {
        return this.formatDescription(job, this.isTrim());
    }

    private String formatDescription(AbstractItem job, boolean trimIt) {
        if (job == null) {
            return null;
        }
        if (job.getDescription() == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (!trimIt) {
            sb.append(job.getDescription());
        } else {
            String[] parts = job.getDescription().split(SEPARATORS_REGEX);
            for (int i = 0; i < this.displayLength && i < parts.length; ++i) {
                if (i != 0) {
                    sb.append(SEPARATOR);
                }
                sb.append(parts[i]);
            }
        }
        return sb.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return Messages.DescriptionColumn_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/extra-columns/help-description-column.html";
        }
    }
}

