/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.extracolumns;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import jenkins.plugins.extracolumns.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildParametersColumn
extends ListViewColumn {
    private boolean useRegex;
    private String regex;

    @DataBoundConstructor
    public BuildParametersColumn(boolean useRegex, String regex) {
        this.useRegex = useRegex;
        this.regex = regex;
    }

    public BuildParametersColumn() {
        this(false, "");
    }

    public boolean isUseRegex() {
        return this.useRegex;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getBuildParameters(Job<?, ?> job) {
        if (job == null || job.getLastBuild() == null) {
            return "";
        }
        Run r = job.getLastBuild();
        StringBuilder s = new StringBuilder();
        for (Action action : r.getAllActions()) {
            if (!(action instanceof ParametersAction)) continue;
            ParametersAction pa = (ParametersAction)action;
            for (ParameterValue p : pa.getParameters()) {
                if (this.isUseRegex() && !p.getName().matches(this.regex)) continue;
                s.append(p.getShortDescription()).append("<br/>");
            }
        }
        return s.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return Messages.BuildParametersColumn_DisplayName();
        }
    }
}

