/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.ExternalRun;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.Run;
import hudson.model.RunMap;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.ViewJob;
import hudson.util.AlternativeUiTextProvider;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalJob
extends ViewJob<ExternalJob, ExternalRun>
implements TopLevelItem {
    private static final Logger LOGGER = Logger.getLogger(ExternalJob.class.getName());
    private transient long lastBuildStartTime;
    @Extension
    public static final TopLevelItemDescriptor DESCRIPTOR = new DescriptorImpl();

    public ExternalJob(String name) {
        this((ItemGroup)Jenkins.getInstance(), name);
    }

    public ExternalJob(ItemGroup parent, String name) {
        super(parent, name);
    }

    protected void reload() {
        this.runs.load((Job)this, (RunMap.Constructor)new RunMap.Constructor<ExternalRun>(){

            public ExternalRun create(File dir) throws IOException {
                return new ExternalRun(ExternalJob.this, dir);
            }
        });
    }

    public void removeRun(ExternalRun run) {
        if (this.runs != null && !this.runs.remove((Run)run)) {
            LOGGER.log(Level.WARNING, "{0} did not contain {1} to begin with", new Object[]{this, run});
        }
    }

    public synchronized ExternalRun newBuild() throws IOException {
        long timeSinceLast = System.currentTimeMillis() - this.lastBuildStartTime;
        if (timeSinceLast < 1000L) {
            try {
                Thread.sleep(1000L - timeSinceLast);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.lastBuildStartTime = System.currentTimeMillis();
        ExternalRun run = new ExternalRun(this);
        this._getRuns();
        this.runs.put((Run)run);
        return run;
    }

    public void doAcceptBuildResult(StaplerResponse rsp) throws IOException, ServletException {
        rsp.setStatus(200);
    }

    public void doPostBuildResult(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkPermission(AbstractProject.BUILD);
        ExternalRun run = this.newBuild();
        run.acceptRemoteSubmission(req.getReader());
        rsp.setStatus(200);
    }

    public TopLevelItemDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public String getPronoun() {
        return AlternativeUiTextProvider.get((AlternativeUiTextProvider.Message)PRONOUN, (Object)((Object)this), (String)Messages.ExternalJob_Pronoun());
    }

    public static final class DescriptorImpl
    extends TopLevelItemDescriptor {
        public String getDisplayName() {
            return Messages.ExternalJob_DisplayName();
        }

        public ExternalJob newInstance(ItemGroup parent, String name) {
            return new ExternalJob(parent, name);
        }
    }
}

