/*
 * Decompiled with CFR 0.152.
 */
package com.cwctravel.hudson.plugins.extended_choice_parameter;

import com.cwctravel.hudson.plugins.extended_choice_parameter.ExtendedChoiceParameterValue;
import com.cwctravel.hudson.plugins.extended_choice_parameter.Messages;
import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Property;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedChoiceParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = -2946187268529865645L;
    public static final String PARAMETER_TYPE_SINGLE_SELECT = "PT_SINGLE_SELECT";
    public static final String PARAMETER_TYPE_MULTI_SELECT = "PT_MULTI_SELECT";
    public static final String PARAMETER_TYPE_CHECK_BOX = "PT_CHECKBOX";
    public static final String PARAMETER_TYPE_RADIO = "PT_RADIO";
    public static final String PARAMETER_TYPE_TEXT_BOX = "PT_TEXTBOX";
    private boolean quoteValue;
    private int visibleItemCount;
    private String type;
    private String value;
    private String propertyFile;
    private String propertyKey;
    private String defaultValue;
    private String defaultPropertyFile;
    private String defaultPropertyKey;

    @DataBoundConstructor
    public ExtendedChoiceParameterDefinition(String name, String type, String value, String propertyFile, String propertyKey, String defaultValue, String defaultPropertyFile, String defaultPropertyKey, boolean quoteValue, int visibleItemCount, String description) {
        super(name, description);
        this.type = type;
        this.propertyFile = propertyFile;
        this.propertyKey = propertyKey;
        this.defaultPropertyFile = defaultPropertyFile;
        this.defaultPropertyKey = defaultPropertyKey;
        this.value = value;
        this.defaultValue = defaultValue;
        this.quoteValue = quoteValue;
        if (visibleItemCount == 0) {
            visibleItemCount = 5;
        }
        this.visibleItemCount = visibleItemCount;
    }

    private Map<String, Boolean> computeDefaultValueMap() {
        HashMap<String, Boolean> defaultValueMap = null;
        String effectiveDefaultValue = this.getEffectiveDefaultValue();
        if (!StringUtils.isBlank((String)effectiveDefaultValue)) {
            String[] defaultValues;
            defaultValueMap = new HashMap<String, Boolean>();
            for (String value : defaultValues = StringUtils.split((String)effectiveDefaultValue, (char)',')) {
                defaultValueMap.put(StringUtils.trim((String)value), true);
            }
        }
        return defaultValueMap;
    }

    public ParameterValue createValue(StaplerRequest request) {
        String[] values = request.getParameterValues(this.getName());
        if (values == null || values.length == 0) {
            return this.getDefaultParameterValue();
        }
        if (PARAMETER_TYPE_TEXT_BOX.equals(this.type)) {
            return new ExtendedChoiceParameterValue(this.getName(), values[0]);
        }
        String defaultValueStr = this.getEffectiveDefaultValue();
        if (defaultValueStr != null) {
            ArrayList<String> result = new ArrayList<String>();
            String[] defaultValues = defaultValueStr.split(",");
            HashSet<String> defaultValueSet = new HashSet<String>();
            for (String defaultValue : defaultValues) {
                defaultValueSet.add(defaultValue);
            }
            for (String value : values) {
                if (!defaultValueSet.contains(value)) continue;
                result.add(value);
            }
            return new ExtendedChoiceParameterValue(this.getName(), StringUtils.join(result, (String)","));
        }
        return null;
    }

    public ParameterValue createValue(StaplerRequest request, JSONObject jO) {
        Object value = jO.get("value");
        String strValue = "";
        if (value instanceof String) {
            strValue = (String)value;
        } else if (value instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)value;
            strValue = StringUtils.join((Iterator)jsonValues.iterator(), (char)',');
        }
        if (this.quoteValue) {
            strValue = "\"" + strValue + "\"";
        }
        return new ExtendedChoiceParameterValue(this.getName(), strValue);
    }

    public ParameterValue getDefaultParameterValue() {
        String defaultValue = this.getEffectiveDefaultValue();
        if (!StringUtils.isBlank((String)defaultValue)) {
            if (this.quoteValue) {
                defaultValue = "\"" + defaultValue + "\"";
            }
            return new ExtendedChoiceParameterValue(this.getName(), defaultValue);
        }
        return super.getDefaultParameterValue();
    }

    private String computeValue(String value, String propertyFilePath, String propertyKey) {
        if (!StringUtils.isBlank((String)this.propertyFile) && !StringUtils.isBlank((String)propertyKey)) {
            try {
                Project project = new Project();
                Property property = new Property();
                property.setProject(project);
                File propertyFile = new File(propertyFilePath);
                if (propertyFile.exists()) {
                    property.setFile(propertyFile);
                } else {
                    URL propertyFileUrl = new URL(propertyFilePath);
                    property.setUrl(propertyFileUrl);
                }
                property.execute();
                return project.getProperty(propertyKey);
            }
            catch (Exception e) {}
        } else if (!StringUtils.isBlank((String)value)) {
            return value;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEffectiveDefaultValue() {
        return this.computeValue(this.defaultValue, this.defaultPropertyFile, this.defaultPropertyKey);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    public String getDefaultPropertyKey() {
        return this.defaultPropertyKey;
    }

    public void setDefaultPropertyKey(String defaultPropertyKey) {
        this.defaultPropertyKey = defaultPropertyKey;
    }

    public String getEffectiveValue() {
        return this.computeValue(this.value, this.propertyFile, this.propertyKey);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public void setPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public String getDefaultPropertyFile() {
        return this.defaultPropertyFile;
    }

    public boolean isQuoteValue() {
        return this.quoteValue;
    }

    public void setQuoteValue(boolean quoteValue) {
        this.quoteValue = quoteValue;
    }

    public int getVisibleItemCount() {
        return this.visibleItemCount;
    }

    public void setVisibleItemCount(int visibleItemCount) {
        this.visibleItemCount = visibleItemCount;
    }

    public void setDefaultPropertyFile(String defaultPropertyFile) {
        this.defaultPropertyFile = defaultPropertyFile;
    }

    public Map<String, Boolean> getDefaultValueMap() {
        return this.computeDefaultValueMap();
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return Messages.ExtendedChoiceParameterDefinition_DisplayName();
        }

        public FormValidation doCheckPropertyFile(@QueryParameter String propertyFile, @QueryParameter String propertyKey) throws IOException, ServletException {
            if (StringUtils.isBlank((String)propertyFile)) {
                return FormValidation.ok();
            }
            Project project = new Project();
            Property property = new Property();
            property.setProject(project);
            File prop = new File(propertyFile);
            try {
                if (prop.exists()) {
                    property.setFile(prop);
                } else {
                    URL propertyFileUrl = new URL(propertyFile);
                    property.setUrl(propertyFileUrl);
                }
                property.execute();
            }
            catch (Exception e) {
                return FormValidation.warning((String)Messages.ExtendedChoiceParameterDefinition_PropertyFileDoesntExist(), (Object[])new Object[]{propertyFile});
            }
            if (StringUtils.isNotBlank((String)propertyKey)) {
                if (project.getProperty(propertyKey) != null) {
                    return FormValidation.ok();
                }
                return FormValidation.warning((String)Messages.ExtendedChoiceParameterDefinition_PropertyFileExistsButProvidedKeyIsInvalid(), (Object[])new Object[]{propertyFile, propertyKey});
            }
            return FormValidation.warning((String)Messages.ExtendedChoiceParameterDefinition_PropertyFileExistsButNoProvidedKey(), (Object[])new Object[]{propertyFile});
        }

        public FormValidation doCheckPropertyKey(@QueryParameter String propertyFile, @QueryParameter String propertyKey) throws IOException, ServletException {
            return this.doCheckPropertyFile(propertyFile, propertyKey);
        }

        public FormValidation doCheckDefaultPropertyFile(@QueryParameter String defaultPropertyFile, @QueryParameter String defaultPropertyKey) throws IOException, ServletException {
            return this.doCheckPropertyFile(defaultPropertyFile, defaultPropertyKey);
        }

        public FormValidation doCheckDefaultPropertyKey(@QueryParameter String defaultPropertyFile, @QueryParameter String defaultPropertyKey) throws IOException, ServletException {
            return this.doCheckPropertyFile(defaultPropertyFile, defaultPropertyKey);
        }
    }
}

