/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.environmentdashboard;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.environmentdashboard.utils.DBConnection;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class EnvDashboardView
extends View {
    private String envOrder = null;
    private String compOrder = null;
    private String deployHistory = null;

    @DataBoundConstructor
    public EnvDashboardView(String name, String envOrder, String compOrder, String deployHistory) {
        super(name, (ViewGroup)Hudson.getInstance());
        this.envOrder = envOrder;
        this.compOrder = compOrder;
        this.deployHistory = deployHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureCorrectDBSchema() {
        String returnComment = "";
        Connection conn = null;
        Statement stat = null;
        conn = DBConnection.getConnection();
        try {
            assert (conn != null);
            stat = conn.createStatement();
        }
        catch (SQLException e) {
            System.out.println("E13" + e.getMessage());
        }
        try {
            stat.execute("ALTER TABLE env_dashboard ADD IF NOT EXISTS packageName VARCHAR(255);");
        }
        catch (SQLException e) {
            System.out.println("E14: Could not alter table to add package column to table env_dashboard.\n" + e.getMessage());
        }
        finally {
            DBConnection.closeConnection();
        }
    }

    protected void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        req.bindJSON((Object)this, req.getSubmittedForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public void doPurgeSubmit(StaplerRequest req, StaplerResponse res) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(Jenkins.ADMINISTER);
        Connection conn = null;
        Statement stat = null;
        conn = DBConnection.getConnection();
        try {
            assert (conn != null);
            stat = conn.createStatement();
            stat.execute("TRUNCATE TABLE env_dashboard");
        }
        catch (SQLException e) {
            System.out.println("E15: Could not truncate table env_dashboard.\n" + e.getMessage());
        }
        finally {
            DBConnection.closeConnection();
        }
        res.forwardToPreviousPage(req);
    }

    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        return Hudson.getInstance().doCreateItem(req, rsp);
    }

    public ArrayList<String> splitEnvOrder(String envOrder) {
        ArrayList<String> orderOfEnvs = new ArrayList<String>();
        if (!"".equals(envOrder)) {
            orderOfEnvs = new ArrayList<String>(Arrays.asList(envOrder.split("\\s*,\\s*")));
        }
        return orderOfEnvs;
    }

    public ArrayList<String> splitCompOrder(String compOrder) {
        ArrayList<String> orderOfComps = new ArrayList<String>();
        if (!"".equals(compOrder)) {
            orderOfComps = new ArrayList<String>(Arrays.asList(compOrder.split("\\s*,\\s*")));
        }
        return orderOfComps;
    }

    public ResultSet runQuery(String queryString) {
        Connection conn = null;
        Statement stat = null;
        ResultSet rs = null;
        conn = DBConnection.getConnection();
        try {
            assert (conn != null);
            stat = conn.createStatement();
        }
        catch (SQLException e) {
            System.out.println("E3" + e.getMessage());
        }
        try {
            assert (stat != null);
            rs = stat.executeQuery(queryString);
        }
        catch (SQLException e) {
            System.out.println("E4" + e.getMessage());
        }
        return rs;
    }

    public ArrayList<String> getOrderOfEnvs() {
        ArrayList<String> orderOfEnvs = this.splitEnvOrder(this.envOrder);
        if (orderOfEnvs == null || orderOfEnvs.isEmpty()) {
            String queryString = "select distinct envname from env_dashboard order by envname;";
            try {
                ResultSet rs = this.runQuery(queryString);
                if (rs == null) {
                    return null;
                }
                while (rs.next()) {
                    if (orderOfEnvs == null) continue;
                    orderOfEnvs.add(rs.getString("envName"));
                }
                DBConnection.closeConnection();
            }
            catch (SQLException e) {
                System.out.println("E6" + e.getMessage());
                return null;
            }
        }
        return orderOfEnvs;
    }

    public ArrayList<String> getOrderOfComps() {
        ArrayList<String> orderOfComps = this.splitCompOrder(this.compOrder);
        if (orderOfComps == null || orderOfComps.isEmpty()) {
            String queryString = "select distinct compname from env_dashboard order by compname;";
            try {
                ResultSet rs = this.runQuery(queryString);
                while (rs.next()) {
                    if (orderOfComps == null) continue;
                    orderOfComps.add(rs.getString("compName"));
                }
                DBConnection.closeConnection();
            }
            catch (SQLException e) {
                System.out.println("E8" + e.getMessage());
                return null;
            }
        }
        return orderOfComps;
    }

    public Integer getLimitDeployHistory() {
        Integer lastDeploy;
        if (this.deployHistory == null || this.deployHistory.equals("")) {
            return 10;
        }
        try {
            lastDeploy = Integer.parseInt(this.deployHistory);
        }
        catch (NumberFormatException e) {
            return 10;
        }
        return lastDeploy;
    }

    public ArrayList<String> getDeployments(String env, Integer lastDeploy) {
        if (lastDeploy <= 0) {
            lastDeploy = 10;
        }
        ArrayList<String> deployments = new ArrayList<String>();
        String queryString = "select top " + lastDeploy + " created_at from env_dashboard where envName ='" + env + "' order by created_at desc;";
        try {
            ResultSet rs = this.runQuery(queryString);
            while (rs.next()) {
                deployments.add(rs.getString("created_at"));
            }
            DBConnection.closeConnection();
        }
        catch (SQLException e) {
            System.out.println("E11" + e.getMessage());
            return null;
        }
        return deployments;
    }

    public String anyJobsConfigured() {
        ArrayList<String> orderOfEnvs = this.getOrderOfEnvs();
        if (orderOfEnvs == null || orderOfEnvs.isEmpty()) {
            return "NONE";
        }
        return "ENVS";
    }

    public String getNiceTimeStamp(String timeStamp) {
        return timeStamp.substring(0, 19);
    }

    public HashMap getCompDeployed(String env, String time) {
        HashMap<Object, String> deployment = new HashMap<Object, String>();
        Object[] fields = new String[]{"buildstatus", "compName", "buildJobUrl", "jobUrl", "buildNum", "packageName"};
        String queryString = "select " + StringUtils.join((Object[])fields, (String)", ").replace(".$", "") + " from env_dashboard where envName = '" + env + "' and created_at = '" + time + "';";
        try {
            ResultSet rs = this.runQuery(queryString);
            rs.next();
            for (Object field : fields) {
                deployment.put(field, rs.getString((String)field));
            }
            DBConnection.closeConnection();
        }
        catch (SQLException e) {
            System.out.println("E10" + e.getMessage());
            System.out.println("Error executing: " + queryString);
        }
        return deployment;
    }

    public ArrayList<String> getCustomDBColumns() {
        return DescriptorImpl.getCustomColumns();
    }

    public ArrayList<HashMap<String, String>> getDeploymentsByComp(String comp, Integer lastDeploy) {
        if (lastDeploy <= 0) {
            lastDeploy = 10;
        }
        ArrayList<HashMap<String, String>> deployments = new ArrayList<HashMap<String, String>>();
        String[] fields = new String[]{"envName", "buildstatus", "buildJobUrl", "jobUrl", "buildNum", "created_at", "packageName"};
        ArrayList<String> allDBFields = this.getCustomDBColumns();
        for (String field : fields) {
            allDBFields.add(field);
        }
        String queryString = "select top " + lastDeploy + " * from env_dashboard where compName='" + comp + "' order by created_at desc;";
        try {
            ResultSet rs = this.runQuery(queryString);
            while (rs.next()) {
                HashMap<String, String> hash = new HashMap<String, String>();
                for (String field : allDBFields) {
                    hash.put(field, rs.getString(field));
                }
                deployments.add(hash);
            }
            DBConnection.closeConnection();
        }
        catch (SQLException e) {
            System.out.println("E11" + e.getMessage());
            return null;
        }
        return deployments;
    }

    public ArrayList<HashMap<String, String>> getDeploymentsByCompEnv(String comp, String env, Integer lastDeploy) {
        if (lastDeploy <= 0) {
            lastDeploy = 10;
        }
        ArrayList<HashMap<String, String>> deployments = new ArrayList<HashMap<String, String>>();
        String[] fields = new String[]{"envName", "buildstatus", "buildJobUrl", "jobUrl", "buildNum", "created_at", "packageName"};
        ArrayList<String> allDBFields = this.getCustomDBColumns();
        for (String field : fields) {
            allDBFields.add(field);
        }
        String queryString = "select top " + lastDeploy + " " + StringUtils.join(allDBFields, (String)", ").replace(".$", "") + " from env_dashboard where compName='" + comp + "' and envName='" + env + "' order by created_at desc;";
        try {
            ResultSet rs = this.runQuery(queryString);
            while (rs.next()) {
                HashMap<String, String> hash = new HashMap<String, String>();
                for (String field : allDBFields) {
                    hash.put(field, rs.getString(field));
                }
                deployments.add(hash);
            }
            DBConnection.closeConnection();
        }
        catch (SQLException e) {
            System.out.println("E11" + e.getMessage());
            return null;
        }
        return deployments;
    }

    public HashMap getCompLastDeployed(String env, String comp) {
        HashMap<String, String> deployment;
        block4: {
            deployment = new HashMap<String, String>();
            String[] fields = new String[]{"buildstatus", "buildJobUrl", "jobUrl", "buildNum", "created_at", "packageName"};
            ArrayList<String> allDBFields = this.getCustomDBColumns();
            for (String field : fields) {
                allDBFields.add(field);
            }
            String queryString = "select top 1 " + StringUtils.join(allDBFields, (String)", ").replace(".$", "") + " from env_dashboard where envName = '" + env + "' and compName = '" + comp + "' order by created_at desc;";
            try {
                ResultSet rs = this.runQuery(queryString);
                rs.next();
                for (String field : allDBFields) {
                    deployment.put(field, rs.getString(field));
                }
                DBConnection.closeConnection();
            }
            catch (SQLException e) {
                if (e.getErrorCode() == 2000) break block4;
                System.out.println("E12" + e.getMessage());
                System.out.println("Error executing: " + queryString);
            }
        }
        return deployment;
    }

    public Collection<TopLevelItem> getItems() {
        return Collections.EMPTY_LIST;
    }

    public String getEnvOrder() {
        return this.envOrder;
    }

    public void setEnvOrder(String envOrder) {
        this.envOrder = envOrder;
    }

    public String getCompOrder() {
        return this.compOrder;
    }

    public void setCompOrder(String compOrder) {
        this.compOrder = compOrder;
    }

    public String getDeployHistory() {
        return this.deployHistory;
    }

    public void setDeployHistory(String deployHistory) {
        this.deployHistory = deployHistory;
    }

    public boolean contains(TopLevelItem topLevelItem) {
        return false;
    }

    public void onJobRenamed(Item item, String s, String s2) {
    }

    static {
        EnvDashboardView.ensureCorrectDBSchema();
    }

    @Extension
    public static final class DescriptorImpl
    extends ViewDescriptor {
        private String envOrder;
        private String compOrder;
        private String deployHistory;

        public DescriptorImpl() {
            this.load();
        }

        public static ArrayList<String> getCustomColumns() {
            Connection conn = null;
            Statement stat = null;
            ArrayList<String> columns = new ArrayList<String>();
            String queryString = "SELECT DISTINCT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS where TABLE_NAME='ENV_DASHBOARD';";
            String[] fields = new String[]{"envComp", "compName", "envName", "buildstatus", "buildJobUrl", "jobUrl", "buildNum", "created_at", "packageName"};
            boolean columnFound = false;
            try {
                ResultSet rs = null;
                conn = DBConnection.getConnection();
                try {
                    assert (conn != null);
                    stat = conn.createStatement();
                }
                catch (SQLException e) {
                    System.out.println("E3" + e.getMessage());
                }
                try {
                    assert (stat != null);
                    rs = stat.executeQuery(queryString);
                }
                catch (SQLException e) {
                    System.out.println("E4" + e.getMessage());
                }
                String col = "";
                while (rs.next()) {
                    columnFound = false;
                    col = rs.getString("COLUMN_NAME");
                    for (String presetColumn : fields) {
                        if (!col.toLowerCase().equals(presetColumn.toLowerCase())) continue;
                        columnFound = true;
                        break;
                    }
                    if (columnFound) continue;
                    columns.add(col.toLowerCase());
                }
                DBConnection.closeConnection();
            }
            catch (SQLException e) {
                System.out.println("E11" + e.getMessage());
                return null;
            }
            return columns;
        }

        public ListBoxModel doFillColumnItems() {
            ListBoxModel m = new ListBoxModel();
            ArrayList<String> columns = DescriptorImpl.getCustomColumns();
            boolean position = false;
            m.add("Select column to remove", "");
            for (String col : columns) {
                m.add(col, col);
            }
            return m;
        }

        public FormValidation doDropColumn(@QueryParameter(value="column") String column) {
            Connection conn = null;
            Statement stat = null;
            if ("".equals(column)) {
                return FormValidation.ok();
            }
            String queryString = "ALTER TABLE ENV_DASHBOARD DROP COLUMN " + column + ";";
            conn = DBConnection.getConnection();
            try {
                assert (conn != null);
                stat = conn.createStatement();
            }
            catch (SQLException e) {
                return FormValidation.error((String)"Failed to create statement.");
            }
            try {
                assert (stat != null);
                stat.execute(queryString);
            }
            catch (SQLException e) {
                DBConnection.closeConnection();
                return FormValidation.error((String)("Failed to remove column: " + column + "\nThis column may have already been removed. Refresh to update the list of columns to remove."));
            }
            DBConnection.closeConnection();
            return FormValidation.ok((String)("Successfully removed column " + column + "."));
        }

        public String getDisplayName() {
            return "Environment Dashboard";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.envOrder = formData.getString("envOrder");
            this.compOrder = formData.getString("compOrder");
            this.deployHistory = formData.getString("deployHistory");
            this.save();
            return super.configure(req, formData);
        }
    }
}

