/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.badge;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class EmbeddableBadgeConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> colors = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("failing", "red");
            this.put("passing", "brightgreen");
            this.put("unstable", "yellow");
            this.put("aborted", "aborted");
            this.put("running", "blue");
        }
    };
    private final String id;
    private String subject = null;
    private String status = null;
    private String color = null;
    private String animatedOverlayColor = null;
    private String link = null;

    public EmbeddableBadgeConfig(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public String getSubject() {
        return this.subject;
    }

    @Whitelisted
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getStatus() {
        return this.status;
    }

    @Whitelisted
    public void setStatus(String status) {
        this.status = status;
    }

    public String getColor() {
        if (this.color == null) {
            return this.colors.get(this.status);
        }
        return this.color;
    }

    @Whitelisted
    public void setColor(String color) {
        this.color = color;
    }

    public String getAnimatedOverlayColor() {
        if (this.animatedOverlayColor == null && this.color == null && this.status != null && this.status.equals("running")) {
            return "blue";
        }
        return this.animatedOverlayColor;
    }

    @Whitelisted
    public void setAnimatedOverlayColor(String animatedOverlayColor) {
        this.animatedOverlayColor = animatedOverlayColor;
    }

    public String getLink() {
        return this.link;
    }

    @Whitelisted
    public void setLink(String link) {
        this.link = link;
    }
}

