/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.content.UserProvidedContentInputStream;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.util.FormValidation;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import org.acegisecurity.Authentication;
import org.apache.commons.io.FilenameUtils;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.scriptsecurity.scripts.Language;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class AbstractEvalContent
extends DataBoundTokenMacro {
    protected static final String EMAIL_TEMPLATES_DIRECTORY = "email-templates";
    protected final String macroName;

    public AbstractEvalContent(String macroName) {
        this.macroName = macroName;
    }

    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)build, build.getWorkspace(), listener, macroName);
    }

    public abstract String evaluate(Run<?, ?> var1, FilePath var2, TaskListener var3, String var4) throws MacroEvaluationException, IOException, InterruptedException;

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(this.macroName);
    }

    public static File scriptsFolder() {
        return new File(Jenkins.get().getRootDir(), EMAIL_TEMPLATES_DIRECTORY);
    }

    protected abstract Class<? extends ConfigProvider> getProviderClass();

    public boolean hasNestedContent() {
        return false;
    }

    protected InputStream getFileInputStream(Run<?, ?> run, FilePath workspace, String fileName, String extension) throws FileNotFoundException, IOException, InterruptedException {
        FilePath file;
        InputStream inputStream = null;
        if (fileName.startsWith("managed:")) {
            String managedFileName = fileName.substring(8);
            try {
                inputStream = this.getManagedFile(run, managedFileName);
            }
            catch (NoClassDefFoundError e) {
                inputStream = null;
            }
            if (inputStream == null) {
                throw new FileNotFoundException(String.format("Managed file '%s' not found", managedFileName));
            }
            return inputStream;
        }
        String fileExt = FilenameUtils.getExtension((String)fileName);
        if ("".equals(fileExt)) {
            fileName = fileName + extension;
        }
        if (workspace != null && (file = workspace.child(fileName)).exists() && AbstractEvalContent.isChildOf(file, workspace)) {
            inputStream = new UserProvidedContentInputStream(file.read());
        }
        if (inputStream == null && (inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("hudson/plugins/emailext/templates/" + fileName)) == null) {
            File templateFile = new File(AbstractEvalContent.scriptsFolder(), fileName);
            if (!templateFile.exists()) {
                fileName = fileName + extension;
                templateFile = new File(AbstractEvalContent.scriptsFolder(), fileName);
            }
            if (!templateFile.exists() || !AbstractEvalContent.isChildOf(new FilePath(templateFile), new FilePath(AbstractEvalContent.scriptsFolder()))) {
                throw new FileNotFoundException(fileName);
            }
            inputStream = new FileInputStream(templateFile);
        }
        return inputStream;
    }

    @Restricted(value={NoExternalUse.class})
    public static boolean isChildOf(FilePath potentialChild, FilePath parent) throws IOException, InterruptedException {
        return (Boolean)parent.act((FilePath.FileCallable)new IsChildFileCallable(potentialChild));
    }

    private InputStream getManagedFile(Run<?, ?> run, String fileName) throws UnsupportedEncodingException {
        ByteArrayInputStream stream = null;
        Plugin plugin = Jenkins.get().getPlugin("config-file-provider");
        if (plugin != null) {
            Config config = null;
            List configs = ConfigFiles.getConfigsInContext((ItemGroup)run.getParent().getParent(), this.getProviderClass());
            for (Config c : configs) {
                if (!c.name.equalsIgnoreCase(fileName)) continue;
                config = c;
                break;
            }
            if (config != null) {
                stream = new ByteArrayInputStream(config.content.getBytes(StandardCharsets.UTF_8));
            }
        }
        return stream;
    }

    protected String generateMissingFile(String type, String fileName) {
        return type + " file [" + fileName + "] was not found in $JENKINS_HOME/" + EMAIL_TEMPLATES_DIRECTORY + ".";
    }

    protected String getCharset(Run<?, ?> build) {
        return ExtendedEmailPublisher.descriptor().getCharset();
    }

    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="The callable is not going to be serialized")
    public static boolean isApprovedScript(final String script, final Language language) {
        final ScriptApproval approval = ScriptApproval.get();
        try {
            return (Boolean)ACL.impersonate((Authentication)Jenkins.ANONYMOUS, (Callable)new NotReallyRoleSensitiveCallable<Boolean, Exception>(){

                public Boolean call() throws Exception {
                    return approval.checking((String)script, (Language)language).kind == FormValidation.Kind.OK;
                }
            });
        }
        catch (Exception e) {
            Logger.getLogger(AbstractEvalContent.class.getName()).log(Level.WARNING, "Could not determine approval state of script.", e);
            return false;
        }
    }

    private static class IsChildFileCallable
    extends MasterToSlaveFileCallable<Boolean> {
        private final FilePath potentialChild;

        private IsChildFileCallable(FilePath potentialChild) {
            this.potentialChild = potentialChild;
        }

        public Boolean invoke(File parent, VirtualChannel channel) throws IOException, InterruptedException {
            FilePath test;
            if (this.potentialChild.isRemote()) {
                return false;
            }
            FilePath target = new FilePath(parent);
            for (test = this.potentialChild.getParent(); test != null && !target.equals((Object)test); test = test.getParent()) {
            }
            return target.equals((Object)test);
        }
    }
}

