/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins;

import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Job;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.mail.internet.InternetAddress;
import jenkins.model.Jenkins;
import org.jsoup.helper.StringUtil;

public abstract class RecipientProvider
extends AbstractDescribableImpl<RecipientProvider>
implements ExtensionPoint {
    private static final Logger LOG = Logger.getLogger(RecipientProvider.class.getName());

    public static DescriptorExtensionList<RecipientProvider, RecipientProviderDescriptor> all() {
        return Jenkins.get().getDescriptorList(RecipientProvider.class);
    }

    public static List<RecipientProviderDescriptor> allSupporting(Class<? extends Job> clazz) {
        ArrayList<RecipientProviderDescriptor> rt = new ArrayList<RecipientProviderDescriptor>();
        for (RecipientProviderDescriptor recipientProviderDescriptor : RecipientProvider.all()) {
            try {
                if (!recipientProviderDescriptor.isApplicable(clazz)) continue;
                rt.add(recipientProviderDescriptor);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, MessageFormat.format("Exception checking if {0} supports {1}, skipping", recipientProviderDescriptor.getDisplayName(), clazz.getName()), ex);
            }
        }
        return rt;
    }

    public static void checkAllSupport(@Nonnull List<? extends RecipientProvider> providers, Class<? extends Job> clazz) {
        TreeSet<String> notSupported = new TreeSet<String>();
        for (RecipientProvider recipientProvider : providers) {
            if (recipientProvider.getDescriptor().isApplicable(clazz)) continue;
            notSupported.add(((Object)((Object)recipientProvider)).getClass().getName());
        }
        if (!notSupported.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format("The following recipient providers do not support {0} {1}", clazz.getName(), StringUtil.join(notSupported, (String)", ")));
        }
    }

    public RecipientProviderDescriptor getDescriptor() {
        return (RecipientProviderDescriptor)super.getDescriptor();
    }

    public abstract void addRecipients(ExtendedEmailPublisherContext var1, EnvVars var2, Set<InternetAddress> var3, Set<InternetAddress> var4, Set<InternetAddress> var5);
}

