/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.mail.internet.InternetAddress;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class EmailExtRecipientStep
extends AbstractStepImpl {
    private List<RecipientProvider> recipientProviders;

    @DataBoundConstructor
    public EmailExtRecipientStep(List<RecipientProvider> recipientProviders) {
        this.recipientProviders = recipientProviders;
    }

    public List<RecipientProvider> getRecipientProviders() {
        return this.recipientProviders;
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Executor.class);
        }

        public String getFunctionName() {
            return "emailextrecipients";
        }

        public String getDisplayName() {
            return "Extended Email Recipients";
        }

        public List<RecipientProviderDescriptor> getRecipientProvidersDescriptors() {
            return RecipientProvider.allSupporting(WorkflowJob.class);
        }
    }

    public static class Executor
    extends AbstractSynchronousNonBlockingStepExecution<String> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient EmailExtRecipientStep step;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient EnvVars env;

        protected String run() throws Exception {
            if (this.step.recipientProviders == null || this.step.recipientProviders.isEmpty()) {
                throw new IllegalArgumentException("You must provide at least one recipient provider");
            }
            ExtendedEmailPublisher publisher = new ExtendedEmailPublisher();
            ExtendedEmailPublisherContext context = new ExtendedEmailPublisherContext(publisher, this.run, null, null, this.listener);
            HashSet<InternetAddress> to = new HashSet<InternetAddress>();
            RecipientProvider.checkAllSupport(this.step.recipientProviders, this.run.getParent().getClass());
            for (RecipientProvider provider : this.step.recipientProviders) {
                provider.addRecipients(context, this.env, to, to, to);
            }
            StringBuilder rt = new StringBuilder();
            Iterator iterator = to.iterator();
            while (iterator.hasNext()) {
                rt.append(((InternetAddress)iterator.next()).toString());
                if (!iterator.hasNext()) continue;
                rt.append(" ");
            }
            return rt.toString();
        }
    }
}

