/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.emailext.plugins.content.AbstractEvalContent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.plugins.configfiles.custom.CustomConfig;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

public class TemplateContent
extends AbstractEvalContent {
    private static final Logger LOGGER = Logger.getLogger(TemplateContent.class.getName());
    @DataBoundTokenMacro.Parameter(required=true)
    public String file = "";
    public static final String MACRO_NAME = "TEMPLATE";

    public TemplateContent() {
        super(MACRO_NAME);
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)build, build.getWorkspace(), listener, macroName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        InputStream inputStream = null;
        String result = "";
        try {
            if (!StringUtils.isEmpty((String)this.file)) {
                result = IOUtils.toString((InputStream)this.getFileInputStream(run, workspace, this.file, ".txt"));
            }
        }
        catch (FileNotFoundException e) {
            String missingFileError = this.generateMissingFile("Plain Text", this.file);
            LOGGER.log(Level.SEVERE, missingFileError, e);
            result = missingFileError;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return result;
    }

    @Override
    protected Class<? extends ConfigProvider> getProviderClass() {
        return CustomConfig.CustomConfigProvider.class;
    }

    @Override
    public boolean hasNestedContent() {
        return true;
    }
}

