/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResult;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;

@Extension
public class FailedTestsContent
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter
    public boolean showStack = true;
    @DataBoundTokenMacro.Parameter
    public boolean showMessage = true;
    @DataBoundTokenMacro.Parameter
    public int maxTests = Integer.MAX_VALUE;
    @DataBoundTokenMacro.Parameter
    public boolean onlyRegressions = false;
    @DataBoundTokenMacro.Parameter
    public int maxLength = Integer.MAX_VALUE;
    @DataBoundTokenMacro.Parameter
    public boolean escapeHtml = false;
    public static final String MACRO_NAME = "FAILED_TESTS";

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) {
        return this.evaluate((Run<?, ?>)build, build.getWorkspace(), listener, macroName);
    }

    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) {
        StringBuilder buffer = new StringBuilder();
        AbstractTestResultAction testResult = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
        if (null == testResult) {
            return "No tests ran.";
        }
        int failCount = testResult.getFailCount();
        if (failCount == 0) {
            buffer.append("All tests passed");
        } else {
            boolean showOldFailures;
            String lineBreak = this.getLineBreak();
            buffer.append(failCount).append(" tests failed.").append(lineBreak);
            boolean bl = showOldFailures = !this.onlyRegressions;
            if (this.maxLength < Integer.MAX_VALUE) {
                this.maxLength *= 1024;
            }
            if (this.maxTests > 0) {
                int printedTests = 0;
                int printedLength = 0;
                for (TestResult failedTest : testResult.getFailedTests()) {
                    if (!showOldFailures && this.getTestAge(failedTest) != 1 || printedTests >= this.maxTests || printedLength > this.maxLength) continue;
                    printedLength += this.outputTest(buffer, failedTest, this.showStack, this.showMessage, this.maxLength - printedLength);
                    ++printedTests;
                }
                if (failCount > printedTests) {
                    buffer.append("... and ").append(failCount - printedTests).append(" other failed tests.").append(lineBreak);
                }
                if (printedLength >= this.maxLength) {
                    buffer.append(lineBreak).append("... output truncated.").append(lineBreak);
                }
            }
        }
        return buffer.toString();
    }

    private int getTestAge(TestResult result) {
        if (result.isPassed()) {
            return 0;
        }
        if (result.getRun() != null) {
            return result.getRun().getNumber() - result.getFailedSince() + 1;
        }
        return 0;
    }

    private int outputTest(StringBuilder buffer, TestResult failedTest, boolean showStack, boolean showMessage, int lengthLeft) {
        StringBuilder local = new StringBuilder();
        String lineBreak = this.getLineBreak();
        local.append(failedTest.isPassed() ? "PASSED" : "FAILED").append(":  ");
        if (failedTest instanceof CaseResult) {
            local.append(((CaseResult)failedTest).getClassName());
        } else {
            local.append(failedTest.getFullName());
        }
        local.append('.').append(failedTest.getDisplayName()).append(lineBreak);
        if (showMessage) {
            String errorDetails = this.escapeHtml ? StringEscapeUtils.escapeHtml((String)failedTest.getErrorDetails()) : failedTest.getErrorDetails();
            local.append(lineBreak).append("Error Message:").append(lineBreak).append(errorDetails).append(lineBreak);
        }
        if (showStack) {
            String stackTrace = this.escapeHtml ? StringEscapeUtils.escapeHtml((String)failedTest.getErrorStackTrace()) : failedTest.getErrorStackTrace();
            local.append(lineBreak).append("Stack Trace:").append(lineBreak).append(stackTrace).append(lineBreak);
        }
        if (showMessage || showStack) {
            local.append(lineBreak);
        }
        if (local.length() > lengthLeft) {
            local.setLength(lengthLeft);
        }
        buffer.append(local.toString());
        return local.length();
    }

    private String getLineBreak() {
        return this.escapeHtml ? "<br/>" : "\n";
    }
}

