/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.Secret;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

public class MailAccount
extends AbstractDescribableImpl<MailAccount> {
    private String address = null;
    private String smtpHost = null;
    private String smtpPort = null;
    private String smtpUsername = null;
    private Secret smtpPassword = null;
    private boolean useSsl = false;
    private String advProperties = null;

    @DataBoundConstructor
    public MailAccount(JSONObject jo) {
        this.address = Util.nullify((String)jo.optString("address", null));
        this.smtpHost = Util.nullify((String)jo.optString("smtpHost", null));
        this.smtpPort = Util.nullify((String)jo.optString("smtpPort", null));
        if (jo.optBoolean("auth", false)) {
            this.smtpUsername = Util.nullify((String)jo.optString("smtpUsername", null));
            this.smtpPassword = Secret.fromString((String)jo.optString("smtpPassword", null));
        }
        this.useSsl = jo.optBoolean("useSsl", false);
        this.advProperties = Util.nullify((String)jo.optString("advProperties", null));
    }

    public MailAccount() {
    }

    public boolean isAuth() {
        return this.smtpUsername != null;
    }

    public String getAddress() {
        return this.address;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    public String getSmtpUsername() {
        return this.smtpUsername;
    }

    public Secret getSmtpPassword() {
        return this.smtpPassword;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public String getAdvProperties() {
        return this.advProperties;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public void setSmtpPort(String smtpPort) {
        this.smtpPort = smtpPort;
    }

    public void setSmtpUsername(String smtpUsername) {
        this.smtpUsername = smtpUsername;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = Secret.fromString((String)smtpPassword);
    }

    public void setSmtpPassword(Secret smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public void setAdvProperties(String advProperties) {
        this.advProperties = advProperties;
    }

    @Extension
    public static class MailAccountDescriptor
    extends Descriptor<MailAccount> {
        public String getDisplayName() {
            return "";
        }
    }
}

