/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import hudson.scm.ChangeLogSet;
import hudson.tasks.Mailer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class UpstreamComitterRecipientProvider
extends RecipientProvider {
    @DataBoundConstructor
    public UpstreamComitterRecipientProvider() {
    }

    @Override
    public void addRecipients(ExtendedEmailPublisherContext context, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc) {
        ExtendedEmailPublisher.descriptor().debug(context.getListener().getLogger(), "Sending email to upstream committer(s).", new Object[0]);
        Cause.UpstreamCause upc = (Cause.UpstreamCause)context.getRun().getCause(Cause.UpstreamCause.class);
        while (upc != null) {
            Job p = (Job)Jenkins.getActiveInstance().getItemByFullName(upc.getUpstreamProject());
            if (p == null) {
                context.getListener().getLogger().print("There is a break in the project linkage, could not retrieve upstream project information");
                break;
            }
            Run cur = p.getBuildByNumber(upc.getUpstreamBuild());
            upc = (Cause.UpstreamCause)cur.getCause(Cause.UpstreamCause.class);
            this.addUpstreamCommittersTriggeringBuild(cur, to, cc, bcc, env, context.getListener());
        }
    }

    private void addUpstreamCommittersTriggeringBuild(Run<?, ?> build, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, EnvVars env, TaskListener listener) {
        ExtendedEmailPublisher.descriptor().debug(listener.getLogger(), "Adding upstream committer from job %s with build number %s", build.getParent().getDisplayName(), build.getNumber());
        List<Object> changeSets = new ArrayList<ChangeLogSet>();
        if (build instanceof AbstractBuild) {
            AbstractBuild b = (AbstractBuild)build;
            changeSets.add(b.getChangeSet());
        } else {
            try {
                Method m = build.getClass().getMethod("getChangeSets", new Class[0]);
                changeSets = (List)m.invoke(build, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                listener.getLogger().print("Could not add upstream committers, build type does not provide change set");
            }
        }
        if (!changeSets.isEmpty()) {
            for (ChangeLogSet changeSet : changeSets) {
                for (ChangeLogSet.Entry change : changeSet) {
                    this.addUserFromChangeSet(change, to, cc, bcc, env, listener);
                }
            }
        }
    }

    private void addUserFromChangeSet(ChangeLogSet.Entry change, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, EnvVars env, TaskListener listener) {
        User user = change.getAuthor();
        String email = ((Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)).getAddress();
        if (email != null) {
            ExtendedEmailPublisher.descriptor().debug(listener.getLogger(), "Adding upstream committer %s to recipient list with email %s", user.getFullName(), email);
            EmailRecipientUtils.addAddressesFromRecipientList(to, cc, bcc, email, env, listener);
        } else {
            ExtendedEmailPublisher.descriptor().debug(listener.getLogger(), "The user %s does not have a configured email email, trying the user's id", user.getFullName());
            EmailRecipientUtils.addAddressesFromRecipientList(to, cc, bcc, user.getId(), env, listener);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends RecipientProviderDescriptor {
        public String getDisplayName() {
            return Messages.UpstreamComitterRecipientProvider_DisplayName();
        }
    }
}

