/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

public class CauseContent
extends DataBoundTokenMacro {
    public static final String MACRO_NAME = "CAUSE";

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        List<Object> causes = new LinkedList<Cause>();
        CauseAction causeAction = (CauseAction)build.getAction(CauseAction.class);
        if (causeAction != null) {
            causes = causeAction.getCauses();
        }
        return this.formatCauses(causes);
    }

    private String formatCauses(List<Cause> causes) {
        if (causes.isEmpty()) {
            return "N/A";
        }
        LinkedList<String> causeNames = new LinkedList<String>();
        for (Cause cause : causes) {
            causeNames.add(cause.getShortDescription());
        }
        return StringUtils.join(causeNames, (String)", ");
    }
}

