/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.plugins.recipients.RequesterRecipientProvider;
import hudson.scm.ChangeLogSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.mail.internet.InternetAddress;

public final class RecipientProviderUtilities {
    private RecipientProviderUtilities() {
    }

    public static Set<User> getChangeSetAuthors(Collection<AbstractBuild<?, ?>> builds, IDebug debug) {
        debug.send("  Collecting change authors...", new Object[0]);
        HashSet<User> users = new HashSet<User>();
        for (AbstractBuild<?, ?> build : builds) {
            debug.send("    build: %d", build.getNumber());
            ChangeLogSet changeLogSet = build.getChangeSet();
            if (changeLogSet == null) {
                debug.send("      changeLogSet was null", new Object[0]);
                continue;
            }
            HashSet<User> changeAuthors = new HashSet<User>();
            for (ChangeLogSet.Entry change : changeLogSet) {
                User changeAuthor = change.getAuthor();
                if (!changeAuthors.add(changeAuthor)) continue;
                debug.send("      adding author: %s", changeAuthor.getFullName());
            }
            users.addAll(changeAuthors);
        }
        return users;
    }

    public static Set<User> getUsersTriggeringTheBuilds(Collection<AbstractBuild<?, ?>> builds, IDebug debug) {
        debug.send("  Collecting build requestors...", new Object[0]);
        HashSet<User> users = new HashSet<User>();
        for (AbstractBuild<?, ?> build : builds) {
            debug.send("    build: %d", build.getNumber());
            User buildRequestor = RequesterRecipientProvider.getUserTriggeringTheBuild(build);
            if (buildRequestor != null) {
                debug.send("      adding requestor: %s", buildRequestor.getFullName());
                users.add(buildRequestor);
                continue;
            }
            debug.send("      buildRequestor was null", new Object[0]);
        }
        return users;
    }

    public static void addUsers(Set<User> users, TaskListener listener, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, IDebug debug) {
        for (User user : users) {
            if (EmailRecipientUtils.isExcludedRecipient(user, listener)) {
                debug.send("User %s is an excluded recipient.", user.getFullName());
                continue;
            }
            String userAddress = EmailRecipientUtils.getUserConfiguredEmail(user);
            if (userAddress != null) {
                debug.send("Adding %s with address %s", user.getFullName(), userAddress);
                EmailRecipientUtils.addAddressesFromRecipientList(to, cc, bcc, userAddress, env, listener);
                continue;
            }
            listener.getLogger().println("Failed to send e-mail to " + user.getFullName() + " because no e-mail address is known, and no default e-mail domain is configured");
        }
    }

    public static interface IDebug {
        public void send(String var1, Object ... var2);
    }
}

