/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

public class BuildLogContent
extends DataBoundTokenMacro {
    public static final String MACRO_NAME = "BUILD_LOG";
    public static final int MAX_LINES_DEFAULT_VALUE = 250;
    @DataBoundTokenMacro.Parameter
    public int maxLines = 250;
    @DataBoundTokenMacro.Parameter
    public boolean escapeHtml = false;

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        StringBuilder buffer = new StringBuilder();
        try {
            List lines = build.getLog(this.maxLines);
            for (String line : lines) {
                if (this.escapeHtml) {
                    line = StringEscapeUtils.escapeHtml((String)line);
                }
                buffer.append(line);
                buffer.append('\n');
            }
        }
        catch (IOException e) {
            listener.getLogger().append("Error getting build log data: " + e.getMessage());
        }
        return buffer.toString();
    }
}

