/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import hudson.scm.ChangeLogSet;
import hudson.tasks.Mailer;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class UpstreamComitterRecipientProvider
extends RecipientProvider {
    private static final ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.getInstance().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);

    @DataBoundConstructor
    public UpstreamComitterRecipientProvider() {
    }

    @Override
    public void addRecipients(ExtendedEmailPublisherContext context, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc) {
        AbstractProject p;
        descriptor.debug(context.getListener().getLogger(), "Sending email to upstream committer(s).", new Object[0]);
        Cause.UpstreamCause upc = (Cause.UpstreamCause)context.getBuild().getCause(Cause.UpstreamCause.class);
        while (upc != null && (p = (AbstractProject)Jenkins.getInstance().getItemByFullName(upc.getUpstreamProject())) != null) {
            AbstractBuild cur = p.getBuildByNumber(upc.getUpstreamBuild());
            upc = (Cause.UpstreamCause)cur.getCause(Cause.UpstreamCause.class);
            this.addUpstreamCommittersTriggeringBuild(cur, to, cc, bcc, env, (TaskListener)context.getListener());
        }
    }

    private void addUpstreamCommittersTriggeringBuild(AbstractBuild<?, ?> build, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, EnvVars env, TaskListener listener) {
        descriptor.debug(listener.getLogger(), "Adding upstream committer from job %s with build number %s", build.getProject().getDisplayName(), build.getNumber());
        for (ChangeLogSet.Entry change : build.getChangeSet()) {
            User user = change.getAuthor();
            String email = ((Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)).getAddress();
            if (email != null) {
                descriptor.debug(listener.getLogger(), "Adding upstream committer %s to recipient list with email %s", user.getFullName(), email);
                EmailRecipientUtils.addAddressesFromRecipientList(to, cc, bcc, email, env, listener);
                continue;
            }
            descriptor.debug(listener.getLogger(), "The user %s does not have a configured email email, trying the user's id", user.getFullName());
            EmailRecipientUtils.addAddressesFromRecipientList(to, cc, bcc, user.getId(), env, listener);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends RecipientProviderDescriptor {
        public String getDisplayName() {
            return Messages.UpstreamComitterRecipientProvider_DisplayName();
        }
    }
}

