/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.ExtensionList;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.JellyTemplateConfig;
import hudson.plugins.emailext.plugins.content.AbstractEvalContent;
import hudson.plugins.emailext.plugins.content.ScriptContentBuildWrapper;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.xml.sax.InputSource;

public class JellyScriptContent
extends AbstractEvalContent {
    public static final String MACRO_NAME = "JELLY_SCRIPT";
    private static final String DEFAULT_HTML_TEMPLATE_NAME = "html";
    private static final String DEFAULT_TEXT_TEMPLATE_NAME = "text";
    private static final String DEFAULT_TEMPLATE_NAME = "html";
    private static final String JELLY_EXTENSION = ".jelly";
    @DataBoundTokenMacro.Parameter
    public String template = "html";

    public JellyScriptContent() {
        super(MACRO_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        String string;
        InputStream inputStream = null;
        try {
            inputStream = this.getFileInputStream(this.template, JELLY_EXTENSION);
            string = this.renderContent(build, inputStream, listener);
        }
        catch (JellyException e) {
            String string2 = "JellyException: " + e.getMessage();
            IOUtils.closeQuietly((InputStream)inputStream);
            return string2;
        }
        catch (FileNotFoundException e2) {
            String missingTemplateError;
            String string3 = missingTemplateError = this.generateMissingFile("Jelly", this.template);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return string3;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return string;
    }

    @Override
    protected ConfigProvider getConfigProvider() {
        if (configProvider == null) {
            ExtensionList providers = ConfigProvider.all();
            configProvider = providers.get(JellyTemplateConfig.JellyTemplateConfigProvider.class);
        }
        return (ConfigProvider)configProvider;
    }

    private String renderContent(AbstractBuild<?, ?> build, InputStream inputStream, TaskListener listener) throws JellyException, IOException {
        JellyContext context = this.createContext(new ScriptContentBuildWrapper(build), build, listener);
        Script script = context.compileScript(new InputSource(inputStream));
        if (script != null) {
            return this.convert(build, context, script);
        }
        return null;
    }

    private String convert(AbstractBuild<?, ?> build, JellyContext context, Script script) throws JellyTagException, IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(16384);
        XMLOutput xmlOutput = XMLOutput.createXMLOutput((OutputStream)output);
        script.run(context, xmlOutput);
        xmlOutput.flush();
        xmlOutput.close();
        output.close();
        return output.toString(this.getCharset(build));
    }

    private JellyContext createContext(Object it, AbstractBuild<?, ?> build, TaskListener listener) {
        JellyContext context = new JellyContext();
        ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.getInstance().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
        context.setVariable("it", it);
        context.setVariable("build", build);
        context.setVariable("project", (Object)build.getParent());
        context.setVariable("logger", (Object)listener.getLogger());
        context.setVariable("rooturl", (Object)descriptor.getHudsonUrl());
        return context;
    }
}

