/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ScriptSandbox;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.recipients.ListRecipientProvider;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.kohsuke.groovy.sandbox.SandboxTransformer;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScriptTrigger
extends EmailTrigger {
    protected String triggerScript;

    @DataBoundConstructor
    public AbstractScriptTrigger(List<RecipientProvider> recipientProviders, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType, String triggerScript) {
        super(recipientProviders, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
        this.triggerScript = triggerScript;
    }

    @Deprecated
    public AbstractScriptTrigger(boolean sendToList, boolean sendToDevs, boolean sendToRequester, boolean sendToCulprits, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType, String triggerScript) {
        super(sendToList, sendToDevs, sendToRequester, sendToCulprits, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
        this.triggerScript = triggerScript;
    }

    public String getTriggerScript() {
        return this.triggerScript;
    }

    @Override
    public boolean configure(StaplerRequest req, JSONObject formData) {
        super.configure(req, formData);
        if (formData.containsKey((Object)"triggerScript")) {
            this.triggerScript = formData.optString("triggerScript", "");
        }
        return true;
    }

    @Override
    public abstract boolean isPreBuild();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trigger(AbstractBuild<?, ?> build, TaskListener listener) {
        boolean result = false;
        GroovyShell engine = this.createEngine(build, listener);
        if (engine != null && !StringUtils.isEmpty((String)this.triggerScript)) {
            Object res = engine.evaluate(this.triggerScript);
            if (res != null) {
                result = (Boolean)res;
            }
        }
        return result;
    }

    private GroovyShell createEngine(AbstractBuild<?, ?> build, TaskListener listener) {
        ClassLoader cl = Jenkins.getInstance().getPluginManager().uberClassLoader;
        ScriptSandbox sandbox = null;
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
        ExtendedEmailPublisher publisher = (ExtendedEmailPublisher)build.getProject().getPublishersList().get(ExtendedEmailPublisher.class);
        if (publisher.getDescriptor().isSecurityEnabled()) {
            cc.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
            sandbox = new ScriptSandbox();
        }
        Binding binding = new Binding();
        binding.setVariable("build", build);
        binding.setVariable("project", (Object)build.getParent());
        binding.setVariable("rooturl", (Object)publisher.getDescriptor().getHudsonUrl());
        binding.setVariable("out", (Object)listener.getLogger());
        GroovyShell shell = new GroovyShell(cl, binding, cc);
        if (sandbox != null) {
            sandbox.register();
        }
        return shell;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DescriptorImpl
    extends EmailTriggerDescriptor {
        @Override
        public List<RecipientProvider> getDefaultRecipientProviders() {
            return new ArrayList<RecipientProvider>(){
                {
                    this.add(new ListRecipientProvider());
                }
            };
        }
    }
}

