/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.ExtensionList;
import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.emailext.GroovyTemplateConfig;
import hudson.plugins.emailext.JellyTemplateConfig;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.content.JellyScriptContent;
import hudson.plugins.emailext.plugins.content.ScriptContent;
import hudson.util.FormValidation;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.bind.JavaScriptMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailExtTemplateAction
implements Action {
    private final AbstractProject<?, ?> project;

    public EmailExtTemplateAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getIconFileName() {
        return "/plugin/email-ext/images/template-debugger.png";
    }

    public String getDisplayName() {
        return Messages.EmailExtTemplateAction_DisplayName();
    }

    public String getUrlName() {
        return "templateTest";
    }

    private String renderError(Exception ex) {
        StringBuilder builder = new StringBuilder();
        builder.append("<h3>An error occured trying to render the template:</h3><br/>");
        builder.append("<span style=\"color:red; font-weight:bold\">");
        builder.append(ex.toString().replace("\n", "<br/>"));
        builder.append("</span>");
        return builder.toString();
    }

    public FormValidation doTemplateFileCheck(@QueryParameter String value) {
        if (!StringUtils.isEmpty((String)value)) {
            if (value.startsWith("managed:")) {
                return this.checkForManagedFile(value);
            }
            File scriptsFolder = new File(Hudson.getInstance().getRootDir(), "email-templates");
            File scriptFile = new File(scriptsFolder, value);
            if (!scriptFile.exists()) {
                return FormValidation.error((String)("The file '" + value + "' does not exist"));
            }
        }
        return FormValidation.ok();
    }

    private FormValidation checkForManagedFile(String value) {
        Plugin plugin = Jenkins.getInstance().getPlugin("config-file-provider");
        if (plugin != null) {
            Object config = null;
            Collection<ConfigProvider> providers = EmailExtTemplateAction.getTemplateConfigProviders();
            for (ConfigProvider provider : providers) {
                for (Config c : provider.getAllConfigs()) {
                    if (!c.name.equalsIgnoreCase(value) || !provider.isResponsibleFor(c.id)) continue;
                    return FormValidation.ok();
                }
            }
        } else {
            return FormValidation.error((String)Messages.EmailExtTemplateAction_ConfigFileProviderNotAvailable());
        }
        return FormValidation.error((String)Messages.EmailExtTemplateAction_ManagedTemplateNotFound());
    }

    private static Collection<ConfigProvider> getTemplateConfigProviders() {
        List<ConfigProvider> providers = Collections.emptyList();
        ExtensionList all = ConfigProvider.all();
        ConfigProvider p = (ConfigProvider)all.get(GroovyTemplateConfig.GroovyTemplateConfigProvider.class);
        if (p != null) {
            providers.add(p);
        }
        if ((p = (ConfigProvider)all.get(JellyTemplateConfig.JellyTemplateConfigProvider.class)) != null) {
            providers.add(p);
        }
        return providers;
    }

    @JavaScriptMethod
    public String renderTemplate(String templateFile, String buildId) {
        String result;
        try {
            AbstractBuild build = this.project.getBuild(buildId);
            if (templateFile.endsWith(".jelly")) {
                JellyScriptContent jellyContent = new JellyScriptContent();
                jellyContent.template = templateFile;
                result = jellyContent.evaluate(build, TaskListener.NULL, "JELLY_SCRIPT");
            } else {
                ScriptContent scriptContent = new ScriptContent();
                scriptContent.template = templateFile;
                result = scriptContent.evaluate(build, TaskListener.NULL, "SCRIPT");
            }
        }
        catch (Exception ex) {
            result = this.renderError(ex);
        }
        return result;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }
}

