/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildLogExcerptContent
extends DataBoundTokenMacro {
    public static final String MACRO_NAME = "BUILD_LOG_EXCERPT";
    @DataBoundTokenMacro.Parameter(required=true)
    public String start;
    @DataBoundTokenMacro.Parameter(required=true)
    public String end;

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        String string;
        BufferedReader reader = new BufferedReader(context.getLogReader());
        try {
            string = this.getContent(reader);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((Reader)reader);
                throw throwable;
            }
            catch (IOException e) {
                listener.getLogger().println("Error getting BUILD_LOG_EXCERPT - " + e.getMessage());
                return "";
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }

    String getContent(BufferedReader reader) throws IOException {
        String line;
        Pattern startPattern = Pattern.compile(this.start);
        Pattern endPattern = Pattern.compile(this.end);
        StringBuilder buffer = new StringBuilder();
        boolean started = false;
        while ((line = reader.readLine()) != null) {
            if (startPattern.matcher(line = ConsoleNote.removeNotes((String)line)).matches()) {
                started = true;
                continue;
            }
            if (endPattern.matcher(line).matches()) break;
            if (!started) continue;
            buffer.append(line).append('\n');
        }
        return buffer.toString();
    }
}

