/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.AttachmentUtils;
import hudson.plugins.emailext.EmailExtTemplateAction;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.MatrixTriggerMode;
import hudson.plugins.emailext.ScriptSandbox;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.plugins.emailext.plugins.CssInliner;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.scm.ChangeLogSet;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.MailMessageIdAction;
import hudson.tasks.Mailer;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.kohsuke.groovy.sandbox.SandboxTransformer;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedEmailPublisher
extends Notifier
implements MatrixAggregatable {
    private static final Logger LOGGER = Logger.getLogger(ExtendedEmailPublisher.class.getName());
    private static final String CONTENT_TRANSFER_ENCODING = System.getProperty(ExtendedEmailPublisher.class.getName() + ".Content-Transfer-Encoding");
    public static final String DEFAULT_RECIPIENTS_TEXT = "";
    public static final String DEFAULT_SUBJECT_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
    public static final String DEFAULT_BODY_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
    public static final String DEFAULT_EMERGENCY_REROUTE_TEXT = "";
    public static final String PROJECT_DEFAULT_SUBJECT_TEXT = "$PROJECT_DEFAULT_SUBJECT";
    public static final String PROJECT_DEFAULT_BODY_TEXT = "$PROJECT_DEFAULT_CONTENT";
    public String recipientList = "";
    public List<EmailTrigger> configuredTriggers = new ArrayList<EmailTrigger>();
    public String contentType;
    public String defaultSubject;
    public String defaultContent;
    public String attachmentsPattern;
    public String presendScript;
    public boolean attachBuildLog;
    public boolean compressBuildLog;
    public String replyTo;
    public boolean saveOutput = false;
    public MatrixTriggerMode matrixTriggerMode;

    @DataBoundConstructor
    public ExtendedEmailPublisher(String project_recipient_list, String project_content_type, String project_default_subject, String project_default_content, String project_attachments, String project_presend_script, int project_attach_buildlog, String project_replyto, boolean project_save_output, List<EmailTrigger> project_triggers, MatrixTriggerMode matrixTriggerMode) {
        this.recipientList = project_recipient_list;
        this.contentType = project_content_type;
        this.defaultSubject = project_default_subject;
        this.defaultContent = project_default_content;
        this.attachmentsPattern = project_attachments;
        this.presendScript = project_presend_script;
        this.attachBuildLog = project_attach_buildlog > 0;
        this.compressBuildLog = project_attach_buildlog > 1;
        this.replyTo = project_replyto;
        this.saveOutput = project_save_output;
        this.configuredTriggers = project_triggers;
        this.matrixTriggerMode = matrixTriggerMode;
    }

    public ExtendedEmailPublisher() {
    }

    public List<EmailTrigger> getConfiguredTriggers() {
        if (this.configuredTriggers == null) {
            this.configuredTriggers = new ArrayList<EmailTrigger>();
        }
        return this.configuredTriggers;
    }

    public MatrixTriggerMode getMatrixTriggerMode() {
        return this.matrixTriggerMode == null ? MatrixTriggerMode.BOTH : this.matrixTriggerMode;
    }

    public void setMatrixTriggerMode(MatrixTriggerMode matrixTriggerMode) {
        this.matrixTriggerMode = matrixTriggerMode;
    }

    public void debug(PrintStream p, String format, Object ... args) {
        this.getDescriptor().debug(p, format, args);
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        if (project.hasPermission(Item.CONFIGURE)) {
            return Collections.singletonList(new EmailExtTemplateAction(project));
        }
        return Collections.EMPTY_LIST;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        this.debug(listener.getLogger(), "Checking for pre-build", new Object[0]);
        if (!(build instanceof MatrixRun) || this.isExecuteOnMatrixNodes()) {
            this.debug(listener.getLogger(), "Executing pre-build step", new Object[0]);
            return this._perform(build, listener, true);
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.debug(listener.getLogger(), "Checking for post-build", new Object[0]);
        if (!(build instanceof MatrixRun) || this.isExecuteOnMatrixNodes()) {
            this.debug(listener.getLogger(), "Performing post-build step", new Object[0]);
            return this._perform(build, listener, false);
        }
        return true;
    }

    private boolean _perform(AbstractBuild<?, ?> build, BuildListener listener, boolean forPreBuild) {
        boolean emailTriggered = false;
        this.debug(listener.getLogger(), "Checking if email needs to be generated", new Object[0]);
        HashMap<String, EmailTrigger> triggered = new HashMap<String, EmailTrigger>();
        for (EmailTrigger trigger : this.getConfiguredTriggers()) {
            if (trigger.isPreBuild() != forPreBuild || !trigger.trigger(build, (TaskListener)listener)) continue;
            String tName = trigger.getDescriptor().getDisplayName();
            triggered.put(tName, trigger);
            listener.getLogger().println("Email was triggered for: " + tName);
            emailTriggered = true;
        }
        ArrayList<String> replacedTriggers = new ArrayList<String>();
        for (String triggerName : triggered.keySet()) {
            replacedTriggers.addAll(((EmailTrigger)triggered.get(triggerName)).getDescriptor().getTriggerReplaceList());
        }
        for (String triggerName : replacedTriggers) {
            triggered.remove(triggerName);
            listener.getLogger().println("Trigger " + triggerName + " was overridden by another trigger and will not send an email.");
        }
        if (emailTriggered && triggered.isEmpty()) {
            listener.getLogger().println("There is a circular trigger replacement with the email triggers.  No email is sent.");
            return false;
        }
        if (triggered.isEmpty()) {
            listener.getLogger().println("No emails were triggered.");
            return true;
        }
        for (String triggerName : triggered.keySet()) {
            listener.getLogger().println("Sending email for trigger: " + triggerName);
            this.sendMail(((EmailTrigger)triggered.get(triggerName)).getEmail(), build, listener, (EmailTrigger)triggered.get(triggerName), triggered);
        }
        return true;
    }

    private boolean sendMail(EmailType mailType, AbstractBuild<?, ?> build, BuildListener listener, EmailTrigger trigger, Map<String, EmailTrigger> triggered) {
        try {
            MimeMessage msg = this.createMail(mailType, build, listener, trigger);
            this.debug(listener.getLogger(), "Successfully created MimeMessage", new Object[0]);
            Address[] allRecipients = msg.getAllRecipients();
            int retries = 0;
            if (allRecipients != null) {
                StringBuilder buf = new StringBuilder("Sending email to:");
                for (Address a : allRecipients) {
                    buf.append(' ').append(a);
                }
                listener.getLogger().println(buf);
                if (this.executePresendScript(build, listener, msg, trigger, triggered)) {
                    while (true) {
                        try {
                            Transport.send((Message)msg);
                        }
                        catch (SendFailedException e) {
                            if (e.getNextException() == null || !(e.getNextException() instanceof SocketException) && !(e.getNextException() instanceof ConnectException)) {
                                Address a2;
                                int i$;
                                Address[] addresses = e.getValidSentAddresses();
                                if (addresses != null && addresses.length > 0) {
                                    buf = new StringBuilder("Successfully sent to the following addresses:");
                                    Address[] arr$ = addresses;
                                    int len$ = arr$.length;
                                    for (i$ = 0; i$ < len$; ++i$) {
                                        a2 = arr$[i$];
                                        buf.append(' ').append(a2);
                                    }
                                    listener.getLogger().println(buf);
                                }
                                if ((addresses = e.getValidUnsentAddresses()) != null && addresses.length > 0) {
                                    buf = new StringBuilder("Error sending to the following VALID addresses:");
                                    Address[] arr$ = addresses;
                                    int len$ = arr$.length;
                                    for (i$ = 0; i$ < len$; ++i$) {
                                        a2 = arr$[i$];
                                        buf.append(' ').append(a2);
                                    }
                                    listener.getLogger().println(buf);
                                }
                                if ((addresses = e.getInvalidAddresses()) != null && addresses.length > 0) {
                                    buf = new StringBuilder("Error sending to the following INVALID addresses:");
                                    for (Address a2 : addresses) {
                                        buf.append(' ').append(a2);
                                    }
                                    listener.getLogger().println(buf);
                                }
                                this.debug(listener.getLogger(), "SendFailedException message: " + e.getMessage(), new Object[0]);
                                break;
                            }
                            listener.getLogger().println("Socket error sending email, retrying once more in 10 seconds...");
                            Thread.sleep(10000L);
                            if (++retries <= 1) continue;
                            listener.getLogger().println("Failed after second try sending email");
                        }
                        break;
                    }
                    if (build.getAction(MailMessageIdAction.class) == null) {
                        build.addAction((Action)new MailMessageIdAction(msg.getMessageID()));
                    }
                } else {
                    listener.getLogger().println("Email sending was cancelled by user script.");
                }
                return true;
            }
            listener.getLogger().println("An attempt to send an e-mail to empty list of recipients, ignored.");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not send email.", e);
            e.printStackTrace(listener.error("Could not send email as a part of the post-build publishers."));
        }
        this.debug(listener.getLogger(), "Some error occured trying to send the email...check the Jenkins log", new Object[0]);
        return false;
    }

    private boolean executePresendScript(AbstractBuild<?, ?> build, BuildListener listener, MimeMessage msg, EmailTrigger trigger, Map<String, EmailTrigger> triggered) throws RuntimeException {
        boolean cancel = false;
        this.presendScript = new ContentBuilder().transformText(this.presendScript, this, build, (TaskListener)listener);
        if (StringUtils.isNotBlank((String)this.presendScript)) {
            this.debug(listener.getLogger(), "Executing pre-send script", new Object[0]);
            ClassLoader cl = Jenkins.getInstance().getPluginManager().uberClassLoader;
            ScriptSandbox sandbox = null;
            CompilerConfiguration cc = new CompilerConfiguration();
            cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
            if (this.getDescriptor().isSecurityEnabled()) {
                this.debug(listener.getLogger(), "Setting up sandbox for pre-send script", new Object[0]);
                cc.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
                sandbox = new ScriptSandbox();
            }
            Binding binding = new Binding();
            binding.setVariable("build", build);
            binding.setVariable("msg", (Object)msg);
            binding.setVariable("logger", (Object)listener.getLogger());
            binding.setVariable("cancel", (Object)cancel);
            binding.setVariable("trigger", (Object)trigger);
            binding.setVariable("triggered", Collections.unmodifiableMap(triggered));
            GroovyShell shell = new GroovyShell(cl, binding, cc);
            StringWriter out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            if (sandbox != null) {
                sandbox.register();
            }
            try {
                Object output = shell.evaluate(this.presendScript);
                if (output != null) {
                    pw.println("Result: " + output);
                    cancel = (Boolean)shell.getVariable("cancel");
                    this.debug(listener.getLogger(), "Pre-send script set cancel to %b", cancel);
                }
            }
            catch (SecurityException e) {
                listener.getLogger().println("Pre-send script tried to access secured objects: " + e.getMessage());
            }
            catch (Throwable t) {
                t.printStackTrace(pw);
                listener.getLogger().println(out.toString());
            }
            this.debug(listener.getLogger(), out.toString(), new Object[0]);
        }
        return !cancel;
    }

    private MimeMessage createMail(EmailType type, AbstractBuild<?, ?> build, BuildListener listener, EmailTrigger trigger) throws MessagingException, IOException, InterruptedException {
        String listId;
        MailMessageIdAction b;
        AbstractBuild pb;
        String emergencyReroute;
        boolean isEmergencyReroute;
        String overrideCharset;
        MimeMessage msg;
        Session session;
        boolean overrideGlobalSettings = this.getDescriptor().getOverrideGlobalSettings();
        if (!overrideGlobalSettings) {
            this.debug(listener.getLogger(), "NOT overriding default server settings, using Mailer to create session", new Object[0]);
            session = Mailer.descriptor().createSession();
            msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(Mailer.descriptor().getAdminAddress()));
        } else {
            this.debug(listener.getLogger(), "Overriding default server settings, creating our own session", new Object[0]);
            session = this.getDescriptor().createSession();
            msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(this.getDescriptor().getAdminAddress()));
        }
        if (this.getDescriptor().isDebugMode()) {
            session.setDebugOut(listener.getLogger());
        }
        String charset = Mailer.descriptor().getCharset();
        if (overrideGlobalSettings && StringUtils.isNotBlank((String)(overrideCharset = this.getDescriptor().getCharset()))) {
            this.debug(listener.getLogger(), "Overriding charset %s", overrideCharset);
            charset = overrideCharset;
        }
        msg.addHeader("X-Jenkins-Job", build.getProject().getDisplayName());
        if (build.getResult() != null) {
            msg.addHeader("X-Jenkins-Result", build.getResult().toString());
        }
        msg.setSentDate(new Date());
        this.setSubject(type, build, msg, listener, charset);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)this.getContent(type, build, listener, charset, trigger));
        AttachmentUtils attachments = new AttachmentUtils(this.attachmentsPattern);
        attachments.attach((Multipart)multipart, this, build, listener);
        if (StringUtils.isNotBlank((String)type.getAttachmentsPattern())) {
            AttachmentUtils typeAttachments = new AttachmentUtils(type.getAttachmentsPattern());
            typeAttachments.attach((Multipart)multipart, this, build, listener);
        }
        if (this.attachBuildLog || type.getAttachBuildLog()) {
            this.debug(listener.getLogger(), "Request made to attach build log", new Object[0]);
            AttachmentUtils.attachBuildLog(this, (Multipart)multipart, build, listener, this.compressBuildLog || type.getCompressBuildLog());
        }
        msg.setContent((Multipart)multipart);
        EnvVars env = null;
        try {
            env = build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            listener.getLogger().println("Error retrieving environment vars: " + e.getMessage());
            env = new EnvVars();
        }
        LinkedHashSet<InternetAddress> recipientAddresses = new LinkedHashSet<InternetAddress>();
        LinkedHashSet<InternetAddress> ccAddresses = new LinkedHashSet<InternetAddress>();
        if (type.getSendToRecipientList()) {
            this.debug(listener.getLogger(), "Adding recipients from recipient list", new Object[0]);
            ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, this.getRecipientList(type, build, this.recipientList, listener, charset), env, listener);
        }
        if (type.getSendToDevelopers()) {
            HashSet<User> users;
            this.debug(listener.getLogger(), "Adding developers", new Object[0]);
            if (type.getSendToCulprits()) {
                users = build.getCulprits();
            } else {
                users = new HashSet<User>();
                for (ChangeLogSet.Entry change : build.getChangeSet()) {
                    users.add(change.getAuthor());
                }
            }
            for (User user : users) {
                if (this.isExcludedRecipient(user, listener)) continue;
                String userAddress = EmailRecipientUtils.getUserConfiguredEmail(user);
                if (userAddress != null) {
                    this.debug(listener.getLogger(), "Adding user address %s, they were not considered an excluded committer", userAddress);
                    ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, userAddress, env, listener);
                    continue;
                }
                listener.getLogger().println("Failed to send e-mail to " + user.getFullName() + " because no e-mail address is known, and no default e-mail domain is configured");
            }
        }
        if (type.getSendToRequester()) {
            AbstractProject p;
            this.debug(listener.getLogger(), "Sending to requester", new Object[0]);
            AbstractBuild cur = build;
            Cause.UpstreamCause upc = (Cause.UpstreamCause)build.getCause(Cause.UpstreamCause.class);
            while (upc != null && (p = (AbstractProject)Jenkins.getInstance().getItemByFullName(upc.getUpstreamProject())) != null) {
                cur = p.getBuildByNumber(upc.getUpstreamBuild());
                upc = (Cause.UpstreamCause)cur.getCause(Cause.UpstreamCause.class);
            }
            this.addUserTriggeringTheBuild(cur, recipientAddresses, ccAddresses, env, listener);
        }
        if (StringUtils.isNotBlank((String)type.getRecipientList())) {
            ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, this.getRecipientList(type, build, type.getRecipientList(), listener, charset), env, listener);
        }
        if (isEmergencyReroute = StringUtils.isNotBlank((String)(emergencyReroute = this.getDescriptor().getEmergencyReroute()))) {
            this.debug(listener.getLogger(), "Emergency reroute turned on", new Object[0]);
            recipientAddresses.clear();
            ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, emergencyReroute, env, listener);
            this.debug(listener.getLogger(), "Emergency reroute is set to: " + emergencyReroute, new Object[0]);
        }
        LinkedHashSet<InternetAddress> excludedRecipients = new LinkedHashSet<InternetAddress>();
        for (InternetAddress recipient : recipientAddresses) {
            if (!this.isExcludedRecipient(recipient.getAddress(), listener)) continue;
            excludedRecipients.add(recipient);
        }
        recipientAddresses.removeAll(excludedRecipients);
        ccAddresses.removeAll(excludedRecipients);
        msg.setRecipients(Message.RecipientType.TO, (Address[])recipientAddresses.toArray(new InternetAddress[recipientAddresses.size()]));
        if (ccAddresses.size() > 0) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses.toArray(new InternetAddress[ccAddresses.size()]));
        }
        LinkedHashSet<InternetAddress> replyToAddresses = new LinkedHashSet<InternetAddress>();
        if (StringUtils.isNotBlank((String)this.replyTo)) {
            ExtendedEmailPublisher.addAddressesFromRecipientList(replyToAddresses, null, this.getRecipientList(type, build, this.replyTo, listener, charset), env, listener);
        }
        if (StringUtils.isNotBlank((String)type.getReplyTo())) {
            ExtendedEmailPublisher.addAddressesFromRecipientList(replyToAddresses, null, this.getRecipientList(type, build, type.getReplyTo(), listener, charset), env, listener);
        }
        if (replyToAddresses.size() > 0) {
            msg.setReplyTo((Address[])replyToAddresses.toArray(new InternetAddress[replyToAddresses.size()]));
        }
        if ((pb = build.getPreviousBuild()) != null && (b = (MailMessageIdAction)pb.getAction(MailMessageIdAction.class)) != null && pb.getResult() != Result.SUCCESS) {
            this.debug(listener.getLogger(), "Setting In-Reply-To since last build was not successful", new Object[0]);
            msg.setHeader("In-Reply-To", b.messageId);
            msg.setHeader("References", b.messageId);
        }
        if (CONTENT_TRANSFER_ENCODING != null) {
            msg.setHeader("Content-Transfer-Encoding", CONTENT_TRANSFER_ENCODING);
        }
        if ((listId = this.getDescriptor().getListId()) != null) {
            msg.setHeader("List-ID", listId);
        }
        if (this.getDescriptor().getPrecedenceBulk()) {
            msg.setHeader("Precedence", "bulk");
        }
        return msg;
    }

    private boolean isExcludedRecipient(String userName, BuildListener listener) {
        StringTokenizer tokens = new StringTokenizer(this.getDescriptor().getExcludedCommitters(), ",");
        while (tokens.hasMoreTokens()) {
            String check = tokens.nextToken().trim();
            this.debug(listener.getLogger(), "Checking '%s' against '%s' to see if they are excluded", userName, check);
            if (!check.equalsIgnoreCase(userName)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludedRecipient(User user, BuildListener listener) {
        String[] testValues;
        for (String testValue : testValues = new String[]{user.getFullName(), user.getId(), user.getDisplayName()}) {
            if (testValue == null || !this.isExcludedRecipient(testValue, listener)) continue;
            return true;
        }
        return false;
    }

    private void addUserTriggeringTheBuild(AbstractBuild<?, ?> build, Set<InternetAddress> recipientAddresses, Set<InternetAddress> ccAddresses, EnvVars env, BuildListener listener) {
        User user = this.getByUserIdCause(build);
        if (user == null) {
            user = this.getByLegacyUserCause(build);
        }
        if (user != null) {
            String adrs = ((Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)).getAddress();
            if (adrs != null) {
                ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, adrs, env, listener);
            } else {
                listener.getLogger().println("The user does not have a configured email address, trying the user's id");
                ExtendedEmailPublisher.addAddressesFromRecipientList(recipientAddresses, ccAddresses, user.getId(), env, listener);
            }
        }
    }

    private User getByUserIdCause(AbstractBuild<?, ?> build) {
        try {
            Class<?> userIdCause = ExtendedEmailPublisher.class.getClassLoader().loadClass("hudson.model.Cause$UserIdCause");
            Method getUserId = userIdCause.getMethod("getUserId", new Class[0]);
            Cause cause = build.getCause(userIdCause);
            if (cause != null) {
                String id = (String)getUserId.invoke((Object)cause, new Object[0]);
                return User.get((String)id, (boolean)false);
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return null;
    }

    private User getByLegacyUserCause(AbstractBuild<?, ?> build) {
        try {
            Cause.UserCause userCause = (Cause.UserCause)build.getCause(Cause.UserCause.class);
            if (userCause != null) {
                Field authenticationName = Cause.UserCause.class.getDeclaredField("authenticationName");
                authenticationName.setAccessible(true);
                String name = (String)authenticationName.get(userCause);
                return User.get((String)name, (boolean)false);
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return null;
    }

    private void setSubject(EmailType type, AbstractBuild<?, ?> build, MimeMessage msg, BuildListener listener, String charset) throws MessagingException {
        String subject = new ContentBuilder().transformText(type.getSubject(), this, build, (TaskListener)listener);
        msg.setSubject(subject, charset);
    }

    private String getRecipientList(EmailType type, AbstractBuild<?, ?> build, String recipients, BuildListener listener, String charset) throws MessagingException {
        String recipientsTransformed = StringUtils.isBlank((String)recipients) ? "" : new ContentBuilder().transformText(recipients, this, build, (TaskListener)listener);
        return recipientsTransformed;
    }

    public boolean isExecuteOnMatrixNodes() {
        MatrixTriggerMode mtm = this.getMatrixTriggerMode();
        return MatrixTriggerMode.BOTH == mtm || MatrixTriggerMode.ONLY_CONFIGURATIONS == mtm;
    }

    private MimeBodyPart getContent(EmailType type, AbstractBuild<?, ?> build, BuildListener listener, String charset, EmailTrigger trigger) throws MessagingException {
        String messageContentType;
        String text = new ContentBuilder().transformText(type.getBody(), this, build, (TaskListener)listener);
        String string = messageContentType = type.getContentType().equals("project") ? this.contentType : type.getContentType();
        if ((messageContentType == null || "default".equals(messageContentType)) && (messageContentType = this.getDescriptor().getDefaultContentType()) == null) {
            messageContentType = "text/plain";
        }
        messageContentType = messageContentType + "; charset=" + charset;
        try {
            if (this.saveOutput) {
                Random random = new Random();
                String extension = ".html";
                if (messageContentType.startsWith("text/plain")) {
                    extension = ".txt";
                }
                FilePath savedOutput = new FilePath(build.getWorkspace(), String.format("%s-%s%d%s", trigger.getDescriptor().getDisplayName(), build.getId(), random.nextInt(), extension));
                savedOutput.write(text, charset);
            }
        }
        catch (IOException e) {
            listener.getLogger().println("Error trying to save email output to file. " + e.getMessage());
        }
        catch (InterruptedException e) {
            listener.getLogger().println("Error trying to save email output to file. " + e.getMessage());
        }
        MimeBodyPart msgPart = new MimeBodyPart();
        this.debug(listener.getLogger(), "messageContentType = %s", messageContentType);
        if (messageContentType.startsWith("text/html")) {
            String inlinedCssHtml = new CssInliner().process(text);
            msgPart.setContent((Object)inlinedCssHtml, messageContentType);
        } else {
            msgPart.setContent((Object)text, messageContentType);
        }
        return msgPart;
    }

    private static void addAddressesFromRecipientList(Set<InternetAddress> addresses, Set<InternetAddress> ccAddresses, String recipientList, EnvVars envVars, BuildListener listener) {
        try {
            Set<InternetAddress> internetAddresses = new EmailRecipientUtils().convertRecipientString(recipientList, envVars, 0);
            addresses.addAll(internetAddresses);
            if (ccAddresses != null) {
                Set<InternetAddress> ccInternetAddresses = new EmailRecipientUtils().convertRecipientString(recipientList, envVars, 1);
                ccAddresses.addAll(ccInternetAddresses);
            }
        }
        catch (AddressException ae) {
            LOGGER.log(Level.WARNING, "Could not create email address.", ae);
            listener.getLogger().println("Failed to create e-mail address for " + ae.getRef());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "Could not create email address.", e);
            listener.getLogger().println("Failed to create e-mail address because of invalid encoding");
        }
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public ExtendedEmailPublisherDescriptor getDescriptor() {
        return (ExtendedEmailPublisherDescriptor)Jenkins.getInstance().getDescriptor(((Object)((Object)this)).getClass());
    }

    public MatrixAggregator createAggregator(MatrixBuild matrixbuild, Launcher launcher, BuildListener buildlistener) {
        return new MatrixAggregator(matrixbuild, launcher, buildlistener){

            public boolean endBuild() throws InterruptedException, IOException {
                LOGGER.log(Level.FINER, "end build of " + this.build.getDisplayName());
                if (ExtendedEmailPublisher.this.getMatrixTriggerMode().forParent) {
                    return ExtendedEmailPublisher.this._perform((AbstractBuild)this.build, this.listener, false);
                }
                return true;
            }

            public boolean startBuild() throws InterruptedException, IOException {
                LOGGER.log(Level.FINER, "end build of " + this.build.getDisplayName());
                if (ExtendedEmailPublisher.this.getMatrixTriggerMode().forParent) {
                    return ExtendedEmailPublisher.this._perform((AbstractBuild)this.build, this.listener, true);
                }
                return true;
            }
        };
    }
}

