/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.trigger.Messages;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImprovementTrigger
extends EmailTrigger {
    public static final String TRIGGER_NAME = "Improvement";

    @DataBoundConstructor
    public ImprovementTrigger(boolean sendToList, boolean sendToDevs, boolean sendToRequestor, boolean sendToCulprits, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType) {
        super(sendToList, sendToDevs, sendToRequestor, sendToCulprits, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
    }

    @Override
    public boolean trigger(AbstractBuild<?, ?> build, TaskListener listener) {
        if (build.getPreviousBuild() == null) {
            return false;
        }
        if (build.getTestResultAction() == null) {
            return false;
        }
        if (build.getPreviousBuild().getTestResultAction() == null) {
            return false;
        }
        int numCurrFailures = this.getNumFailures(build);
        return build.getTestResultAction().getTotalCount() > 0 && numCurrFailures < this.getNumFailures(build.getPreviousBuild()) && numCurrFailures > 0;
    }

    @Extension
    public static final class DescriptorImpl
    extends EmailTriggerDescriptor {
        public DescriptorImpl() {
            this.addTriggerNameToReplace("Unstable");
            this.addTriggerNameToReplace("Still Unstable");
        }

        public String getDisplayName() {
            return ImprovementTrigger.TRIGGER_NAME;
        }

        public void doHelp(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            rsp.getWriter().println(Messages.ImprovementTrigger_HelpText());
        }

        public boolean getDefaultSendToDevs() {
            return true;
        }

        public boolean getDefaultSendToList() {
            return true;
        }
    }
}

