/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.trigger.Messages;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbortedTrigger
extends EmailTrigger {
    public static final String TRIGGER_NAME = "Aborted";
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public AbortedTrigger(boolean sendToList, boolean sendToDevs, boolean sendToRequestor, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog) {
        super(sendToList, sendToDevs, sendToRequestor, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog);
    }

    @Override
    public boolean trigger(AbstractBuild<?, ?> build, TaskListener listener) {
        Result buildResult = build.getResult();
        return buildResult == Result.ABORTED;
    }

    @Override
    public EmailTriggerDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends EmailTriggerDescriptor {
        public String getDisplayName() {
            return AbortedTrigger.TRIGGER_NAME;
        }

        public void doHelp(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            rsp.getWriter().println(Messages.AbortedTrigger_HelpText());
        }

        public boolean getDefaultSendToDevs() {
            return true;
        }

        public boolean getDefaultSendToList() {
            return true;
        }
    }
}

